/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.nimble.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum StudioComponentStatusCode {
    ACTIVE_DIRECTORY_ALREADY_EXISTS("ACTIVE_DIRECTORY_ALREADY_EXISTS"),
    STUDIO_COMPONENT_CREATED("STUDIO_COMPONENT_CREATED"),
    STUDIO_COMPONENT_UPDATED("STUDIO_COMPONENT_UPDATED"),
    STUDIO_COMPONENT_DELETED("STUDIO_COMPONENT_DELETED"),
    ENCRYPTION_KEY_ACCESS_DENIED("ENCRYPTION_KEY_ACCESS_DENIED"),
    ENCRYPTION_KEY_NOT_FOUND("ENCRYPTION_KEY_NOT_FOUND"),
    STUDIO_COMPONENT_CREATE_IN_PROGRESS("STUDIO_COMPONENT_CREATE_IN_PROGRESS"),
    STUDIO_COMPONENT_UPDATE_IN_PROGRESS("STUDIO_COMPONENT_UPDATE_IN_PROGRESS"),
    STUDIO_COMPONENT_DELETE_IN_PROGRESS("STUDIO_COMPONENT_DELETE_IN_PROGRESS"),
    INTERNAL_ERROR("INTERNAL_ERROR"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, StudioComponentStatusCode> VALUE_MAP;
    private final String value;

    private StudioComponentStatusCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static StudioComponentStatusCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<StudioComponentStatusCode> knownValues() {
        EnumSet<StudioComponentStatusCode> knownValues = EnumSet.allOf(StudioComponentStatusCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(StudioComponentStatusCode.class, StudioComponentStatusCode::toString);
    }
}

