/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.nimble.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum StudioComponentSubtype {
    AWS_MANAGED_MICROSOFT_AD("AWS_MANAGED_MICROSOFT_AD"),
    AMAZON_FSX_FOR_WINDOWS("AMAZON_FSX_FOR_WINDOWS"),
    AMAZON_FSX_FOR_LUSTRE("AMAZON_FSX_FOR_LUSTRE"),
    CUSTOM("CUSTOM"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, StudioComponentSubtype> VALUE_MAP;
    private final String value;

    private StudioComponentSubtype(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static StudioComponentSubtype fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<StudioComponentSubtype> knownValues() {
        EnumSet<StudioComponentSubtype> knownValues = EnumSet.allOf(StudioComponentSubtype.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(StudioComponentSubtype.class, StudioComponentSubtype::toString);
    }
}

