/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.nimble.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.nimble.NimbleAsyncClient;
import software.amazon.awssdk.services.nimble.model.EulaAcceptance;
import software.amazon.awssdk.services.nimble.model.ListEulaAcceptancesRequest;
import software.amazon.awssdk.services.nimble.model.ListEulaAcceptancesResponse;

public class ListEulaAcceptancesPublisher
implements SdkPublisher<ListEulaAcceptancesResponse> {
    private final NimbleAsyncClient client;
    private final ListEulaAcceptancesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListEulaAcceptancesPublisher(NimbleAsyncClient client, ListEulaAcceptancesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListEulaAcceptancesPublisher(NimbleAsyncClient client, ListEulaAcceptancesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListEulaAcceptancesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListEulaAcceptancesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<EulaAcceptance> eulaAcceptances() {
        Function<ListEulaAcceptancesResponse, Iterator> getIterator = response -> {
            if (response != null && response.eulaAcceptances() != null) {
                return response.eulaAcceptances().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListEulaAcceptancesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListEulaAcceptancesResponseFetcher
    implements AsyncPageFetcher<ListEulaAcceptancesResponse> {
        private ListEulaAcceptancesResponseFetcher() {
        }

        public boolean hasNextPage(ListEulaAcceptancesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListEulaAcceptancesResponse> nextPage(ListEulaAcceptancesResponse previousPage) {
            if (previousPage == null) {
                return ListEulaAcceptancesPublisher.this.client.listEulaAcceptances(ListEulaAcceptancesPublisher.this.firstRequest);
            }
            return ListEulaAcceptancesPublisher.this.client.listEulaAcceptances((ListEulaAcceptancesRequest)((Object)ListEulaAcceptancesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

