/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53resolver.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Action {
    ALLOW("ALLOW"),
    BLOCK("BLOCK"),
    ALERT("ALERT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Action> VALUE_MAP;
    private final String value;

    private Action(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Action fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Action> knownValues() {
        EnumSet<Action> knownValues = EnumSet.allOf(Action.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Action.class, Action::toString);
    }
}

