/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workmail.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workmail.model.AccessControlRuleEffect;
import software.amazon.awssdk.services.workmail.model.ActionsListCopier;
import software.amazon.awssdk.services.workmail.model.IpRangeListCopier;
import software.amazon.awssdk.services.workmail.model.UserIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AccessControlRule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AccessControlRule> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(AccessControlRule.getter(AccessControlRule::name)).setter(AccessControlRule.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> EFFECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Effect").getter(AccessControlRule.getter(AccessControlRule::effectAsString)).setter(AccessControlRule.setter(Builder::effect)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Effect").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(AccessControlRule.getter(AccessControlRule::description)).setter(AccessControlRule.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<List<String>> IP_RANGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IpRanges").getter(AccessControlRule.getter(AccessControlRule::ipRanges)).setter(AccessControlRule.setter(Builder::ipRanges)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpRanges").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> NOT_IP_RANGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NotIpRanges").getter(AccessControlRule.getter(AccessControlRule::notIpRanges)).setter(AccessControlRule.setter(Builder::notIpRanges)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotIpRanges").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Actions").getter(AccessControlRule.getter(AccessControlRule::actions)).setter(AccessControlRule.setter(Builder::actions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Actions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> NOT_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NotActions").getter(AccessControlRule.getter(AccessControlRule::notActions)).setter(AccessControlRule.setter(Builder::notActions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotActions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> USER_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UserIds").getter(AccessControlRule.getter(AccessControlRule::userIds)).setter(AccessControlRule.setter(Builder::userIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> NOT_USER_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NotUserIds").getter(AccessControlRule.getter(AccessControlRule::notUserIds)).setter(AccessControlRule.setter(Builder::notUserIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotUserIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> DATE_CREATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DateCreated").getter(AccessControlRule.getter(AccessControlRule::dateCreated)).setter(AccessControlRule.setter(Builder::dateCreated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateCreated").build()}).build();
    private static final SdkField<Instant> DATE_MODIFIED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DateModified").getter(AccessControlRule.getter(AccessControlRule::dateModified)).setter(AccessControlRule.setter(Builder::dateModified)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateModified").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, EFFECT_FIELD, DESCRIPTION_FIELD, IP_RANGES_FIELD, NOT_IP_RANGES_FIELD, ACTIONS_FIELD, NOT_ACTIONS_FIELD, USER_IDS_FIELD, NOT_USER_IDS_FIELD, DATE_CREATED_FIELD, DATE_MODIFIED_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String effect;
    private final String description;
    private final List<String> ipRanges;
    private final List<String> notIpRanges;
    private final List<String> actions;
    private final List<String> notActions;
    private final List<String> userIds;
    private final List<String> notUserIds;
    private final Instant dateCreated;
    private final Instant dateModified;

    private AccessControlRule(BuilderImpl builder) {
        this.name = builder.name;
        this.effect = builder.effect;
        this.description = builder.description;
        this.ipRanges = builder.ipRanges;
        this.notIpRanges = builder.notIpRanges;
        this.actions = builder.actions;
        this.notActions = builder.notActions;
        this.userIds = builder.userIds;
        this.notUserIds = builder.notUserIds;
        this.dateCreated = builder.dateCreated;
        this.dateModified = builder.dateModified;
    }

    public final String name() {
        return this.name;
    }

    public final AccessControlRuleEffect effect() {
        return AccessControlRuleEffect.fromValue(this.effect);
    }

    public final String effectAsString() {
        return this.effect;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasIpRanges() {
        return this.ipRanges != null && !(this.ipRanges instanceof SdkAutoConstructList);
    }

    public final List<String> ipRanges() {
        return this.ipRanges;
    }

    public final boolean hasNotIpRanges() {
        return this.notIpRanges != null && !(this.notIpRanges instanceof SdkAutoConstructList);
    }

    public final List<String> notIpRanges() {
        return this.notIpRanges;
    }

    public final boolean hasActions() {
        return this.actions != null && !(this.actions instanceof SdkAutoConstructList);
    }

    public final List<String> actions() {
        return this.actions;
    }

    public final boolean hasNotActions() {
        return this.notActions != null && !(this.notActions instanceof SdkAutoConstructList);
    }

    public final List<String> notActions() {
        return this.notActions;
    }

    public final boolean hasUserIds() {
        return this.userIds != null && !(this.userIds instanceof SdkAutoConstructList);
    }

    public final List<String> userIds() {
        return this.userIds;
    }

    public final boolean hasNotUserIds() {
        return this.notUserIds != null && !(this.notUserIds instanceof SdkAutoConstructList);
    }

    public final List<String> notUserIds() {
        return this.notUserIds;
    }

    public final Instant dateCreated() {
        return this.dateCreated;
    }

    public final Instant dateModified() {
        return this.dateModified;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.effectAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIpRanges() ? this.ipRanges() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNotIpRanges() ? this.notIpRanges() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActions() ? this.actions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNotActions() ? this.notActions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserIds() ? this.userIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNotUserIds() ? this.notUserIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dateCreated());
        hashCode = 31 * hashCode + Objects.hashCode(this.dateModified());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccessControlRule)) {
            return false;
        }
        AccessControlRule other = (AccessControlRule)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.effectAsString(), other.effectAsString()) && Objects.equals(this.description(), other.description()) && this.hasIpRanges() == other.hasIpRanges() && Objects.equals(this.ipRanges(), other.ipRanges()) && this.hasNotIpRanges() == other.hasNotIpRanges() && Objects.equals(this.notIpRanges(), other.notIpRanges()) && this.hasActions() == other.hasActions() && Objects.equals(this.actions(), other.actions()) && this.hasNotActions() == other.hasNotActions() && Objects.equals(this.notActions(), other.notActions()) && this.hasUserIds() == other.hasUserIds() && Objects.equals(this.userIds(), other.userIds()) && this.hasNotUserIds() == other.hasNotUserIds() && Objects.equals(this.notUserIds(), other.notUserIds()) && Objects.equals(this.dateCreated(), other.dateCreated()) && Objects.equals(this.dateModified(), other.dateModified());
    }

    public final String toString() {
        return ToString.builder((String)"AccessControlRule").add("Name", (Object)this.name()).add("Effect", (Object)this.effectAsString()).add("Description", (Object)this.description()).add("IpRanges", this.hasIpRanges() ? this.ipRanges() : null).add("NotIpRanges", this.hasNotIpRanges() ? this.notIpRanges() : null).add("Actions", this.hasActions() ? this.actions() : null).add("NotActions", this.hasNotActions() ? this.notActions() : null).add("UserIds", this.hasUserIds() ? this.userIds() : null).add("NotUserIds", this.hasNotUserIds() ? this.notUserIds() : null).add("DateCreated", (Object)this.dateCreated()).add("DateModified", (Object)this.dateModified()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Effect": {
                return Optional.ofNullable(clazz.cast(this.effectAsString()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "IpRanges": {
                return Optional.ofNullable(clazz.cast(this.ipRanges()));
            }
            case "NotIpRanges": {
                return Optional.ofNullable(clazz.cast(this.notIpRanges()));
            }
            case "Actions": {
                return Optional.ofNullable(clazz.cast(this.actions()));
            }
            case "NotActions": {
                return Optional.ofNullable(clazz.cast(this.notActions()));
            }
            case "UserIds": {
                return Optional.ofNullable(clazz.cast(this.userIds()));
            }
            case "NotUserIds": {
                return Optional.ofNullable(clazz.cast(this.notUserIds()));
            }
            case "DateCreated": {
                return Optional.ofNullable(clazz.cast(this.dateCreated()));
            }
            case "DateModified": {
                return Optional.ofNullable(clazz.cast(this.dateModified()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AccessControlRule, T> g) {
        return obj -> g.apply((AccessControlRule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String effect;
        private String description;
        private List<String> ipRanges = DefaultSdkAutoConstructList.getInstance();
        private List<String> notIpRanges = DefaultSdkAutoConstructList.getInstance();
        private List<String> actions = DefaultSdkAutoConstructList.getInstance();
        private List<String> notActions = DefaultSdkAutoConstructList.getInstance();
        private List<String> userIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> notUserIds = DefaultSdkAutoConstructList.getInstance();
        private Instant dateCreated;
        private Instant dateModified;

        private BuilderImpl() {
        }

        private BuilderImpl(AccessControlRule model) {
            this.name(model.name);
            this.effect(model.effect);
            this.description(model.description);
            this.ipRanges(model.ipRanges);
            this.notIpRanges(model.notIpRanges);
            this.actions(model.actions);
            this.notActions(model.notActions);
            this.userIds(model.userIds);
            this.notUserIds(model.notUserIds);
            this.dateCreated(model.dateCreated);
            this.dateModified(model.dateModified);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getEffect() {
            return this.effect;
        }

        public final void setEffect(String effect) {
            this.effect = effect;
        }

        @Override
        @Transient
        public final Builder effect(String effect) {
            this.effect = effect;
            return this;
        }

        @Override
        @Transient
        public final Builder effect(AccessControlRuleEffect effect) {
            this.effect(effect == null ? null : effect.toString());
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getIpRanges() {
            if (this.ipRanges instanceof SdkAutoConstructList) {
                return null;
            }
            return this.ipRanges;
        }

        public final void setIpRanges(Collection<String> ipRanges) {
            this.ipRanges = IpRangeListCopier.copy(ipRanges);
        }

        @Override
        @Transient
        public final Builder ipRanges(Collection<String> ipRanges) {
            this.ipRanges = IpRangeListCopier.copy(ipRanges);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder ipRanges(String ... ipRanges) {
            this.ipRanges(Arrays.asList(ipRanges));
            return this;
        }

        public final Collection<String> getNotIpRanges() {
            if (this.notIpRanges instanceof SdkAutoConstructList) {
                return null;
            }
            return this.notIpRanges;
        }

        public final void setNotIpRanges(Collection<String> notIpRanges) {
            this.notIpRanges = IpRangeListCopier.copy(notIpRanges);
        }

        @Override
        @Transient
        public final Builder notIpRanges(Collection<String> notIpRanges) {
            this.notIpRanges = IpRangeListCopier.copy(notIpRanges);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder notIpRanges(String ... notIpRanges) {
            this.notIpRanges(Arrays.asList(notIpRanges));
            return this;
        }

        public final Collection<String> getActions() {
            if (this.actions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.actions;
        }

        public final void setActions(Collection<String> actions) {
            this.actions = ActionsListCopier.copy(actions);
        }

        @Override
        @Transient
        public final Builder actions(Collection<String> actions) {
            this.actions = ActionsListCopier.copy(actions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder actions(String ... actions) {
            this.actions(Arrays.asList(actions));
            return this;
        }

        public final Collection<String> getNotActions() {
            if (this.notActions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.notActions;
        }

        public final void setNotActions(Collection<String> notActions) {
            this.notActions = ActionsListCopier.copy(notActions);
        }

        @Override
        @Transient
        public final Builder notActions(Collection<String> notActions) {
            this.notActions = ActionsListCopier.copy(notActions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder notActions(String ... notActions) {
            this.notActions(Arrays.asList(notActions));
            return this;
        }

        public final Collection<String> getUserIds() {
            if (this.userIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.userIds;
        }

        public final void setUserIds(Collection<String> userIds) {
            this.userIds = UserIdListCopier.copy(userIds);
        }

        @Override
        @Transient
        public final Builder userIds(Collection<String> userIds) {
            this.userIds = UserIdListCopier.copy(userIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder userIds(String ... userIds) {
            this.userIds(Arrays.asList(userIds));
            return this;
        }

        public final Collection<String> getNotUserIds() {
            if (this.notUserIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.notUserIds;
        }

        public final void setNotUserIds(Collection<String> notUserIds) {
            this.notUserIds = UserIdListCopier.copy(notUserIds);
        }

        @Override
        @Transient
        public final Builder notUserIds(Collection<String> notUserIds) {
            this.notUserIds = UserIdListCopier.copy(notUserIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder notUserIds(String ... notUserIds) {
            this.notUserIds(Arrays.asList(notUserIds));
            return this;
        }

        public final Instant getDateCreated() {
            return this.dateCreated;
        }

        public final void setDateCreated(Instant dateCreated) {
            this.dateCreated = dateCreated;
        }

        @Override
        @Transient
        public final Builder dateCreated(Instant dateCreated) {
            this.dateCreated = dateCreated;
            return this;
        }

        public final Instant getDateModified() {
            return this.dateModified;
        }

        public final void setDateModified(Instant dateModified) {
            this.dateModified = dateModified;
        }

        @Override
        @Transient
        public final Builder dateModified(Instant dateModified) {
            this.dateModified = dateModified;
            return this;
        }

        public AccessControlRule build() {
            return new AccessControlRule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AccessControlRule> {
        public Builder name(String var1);

        public Builder effect(String var1);

        public Builder effect(AccessControlRuleEffect var1);

        public Builder description(String var1);

        public Builder ipRanges(Collection<String> var1);

        public Builder ipRanges(String ... var1);

        public Builder notIpRanges(Collection<String> var1);

        public Builder notIpRanges(String ... var1);

        public Builder actions(Collection<String> var1);

        public Builder actions(String ... var1);

        public Builder notActions(Collection<String> var1);

        public Builder notActions(String ... var1);

        public Builder userIds(Collection<String> var1);

        public Builder userIds(String ... var1);

        public Builder notUserIds(Collection<String> var1);

        public Builder notUserIds(String ... var1);

        public Builder dateCreated(Instant var1);

        public Builder dateModified(Instant var1);
    }
}

