/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workmail.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PermissionType {
    FULL_ACCESS("FULL_ACCESS"),
    SEND_AS("SEND_AS"),
    SEND_ON_BEHALF("SEND_ON_BEHALF"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PermissionType> VALUE_MAP;
    private final String value;

    private PermissionType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PermissionType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PermissionType> knownValues() {
        EnumSet<PermissionType> knownValues = EnumSet.allOf(PermissionType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PermissionType.class, PermissionType::toString);
    }
}

