/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workmail.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum UserRole {
    USER("USER"),
    RESOURCE("RESOURCE"),
    SYSTEM_USER("SYSTEM_USER"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, UserRole> VALUE_MAP;
    private final String value;

    private UserRole(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static UserRole fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<UserRole> knownValues() {
        EnumSet<UserRole> knownValues = EnumSet.allOf(UserRole.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(UserRole.class, UserRole::toString);
    }
}

