/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.core.lock;

import com.alibaba.fastjson.JSON;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Maps;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import tech.powerjob.server.common.utils.AOPUtils;
import tech.powerjob.server.core.lock.UseCacheLock;
import tech.powerjob.server.monitor.Event;
import tech.powerjob.server.monitor.MonitorService;
import tech.powerjob.server.monitor.events.lock.SlowLockEvent;

@Aspect
@Component
@Order(value=1)
public class UseCacheLockAspect {
    private static final Logger log = LoggerFactory.getLogger(UseCacheLockAspect.class);
    private final MonitorService monitorService;
    private final Map<String, Cache<String, ReentrantLock>> lockContainer = Maps.newConcurrentMap();
    private static final long SLOW_THRESHOLD = 100L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="@annotation(useCacheLock))")
    public Object execute(ProceedingJoinPoint point, UseCacheLock useCacheLock) throws Throwable {
        Cache lockCache = this.lockContainer.computeIfAbsent(useCacheLock.type(), ignore -> {
            int concurrencyLevel = useCacheLock.concurrencyLevel();
            log.info("[UseSegmentLockAspect] create Lock Cache for [{}] with concurrencyLevel: {}", (Object)useCacheLock.type(), (Object)concurrencyLevel);
            return CacheBuilder.newBuilder().initialCapacity(300000).maximumSize(500000L).concurrencyLevel(concurrencyLevel).expireAfterWrite(30L, TimeUnit.MINUTES).build();
        });
        Method method = AOPUtils.parseMethod((ProceedingJoinPoint)point);
        Long key = (Long)AOPUtils.parseSpEl((Method)method, (Object[])point.getArgs(), (String)useCacheLock.key(), Long.class, (Object)1L);
        ReentrantLock reentrantLock = (ReentrantLock)lockCache.get((Object)String.valueOf(key), ReentrantLock::new);
        long start = System.currentTimeMillis();
        reentrantLock.lockInterruptibly();
        try {
            long timeCost = System.currentTimeMillis() - start;
            if (timeCost > 100L) {
                SlowLockEvent slowLockEvent = new SlowLockEvent().setType(SlowLockEvent.Type.LOCAL).setLockType(useCacheLock.type()).setLockKey(String.valueOf(key)).setCallerService(method.getDeclaringClass().getSimpleName()).setCallerMethod(method.getName()).setCost(timeCost);
                this.monitorService.monitor((Event)slowLockEvent);
                log.warn("[UseSegmentLockAspect] wait lock for method({}#{}) cost {} ms! key = '{}', args = {}, ", new Object[]{method.getDeclaringClass().getSimpleName(), method.getName(), timeCost, key, JSON.toJSONString((Object)point.getArgs())});
            }
            Object object = point.proceed();
            return object;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    public UseCacheLockAspect(MonitorService monitorService) {
        this.monitorService = monitorService;
    }
}

