/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.core.service;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.time.Duration;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import tech.powerjob.server.persistence.remote.model.InstanceInfoDO;
import tech.powerjob.server.persistence.remote.model.JobInfoDO;
import tech.powerjob.server.persistence.remote.model.WorkflowInfoDO;
import tech.powerjob.server.persistence.remote.repository.InstanceInfoRepository;
import tech.powerjob.server.persistence.remote.repository.JobInfoRepository;
import tech.powerjob.server.persistence.remote.repository.WorkflowInfoRepository;

@Service
public class CacheService {
    private static final Logger log = LoggerFactory.getLogger(CacheService.class);
    private final JobInfoRepository jobInfoRepository;
    private final WorkflowInfoRepository workflowInfoRepository;
    private final InstanceInfoRepository instanceInfoRepository;
    private final Cache<Long, String> jobId2JobNameCache;
    private final Cache<Long, String> workflowId2WorkflowNameCache;
    private final Cache<Long, Long> instanceId2AppId;
    private final Cache<Long, Long> jobId2AppId;

    public CacheService(JobInfoRepository jobInfoRepository, WorkflowInfoRepository workflowInfoRepository, InstanceInfoRepository instanceInfoRepository) {
        this.jobInfoRepository = jobInfoRepository;
        this.workflowInfoRepository = workflowInfoRepository;
        this.instanceInfoRepository = instanceInfoRepository;
        this.jobId2JobNameCache = CacheBuilder.newBuilder().expireAfterWrite(Duration.ofMinutes(1L)).maximumSize(512L).softValues().build();
        this.workflowId2WorkflowNameCache = CacheBuilder.newBuilder().expireAfterWrite(Duration.ofMinutes(1L)).maximumSize(512L).softValues().build();
        this.instanceId2AppId = CacheBuilder.newBuilder().maximumSize(1024L).softValues().build();
        this.jobId2AppId = CacheBuilder.newBuilder().maximumSize(1024L).softValues().build();
    }

    public String getJobName(Long jobId) {
        try {
            return (String)this.jobId2JobNameCache.get((Object)jobId, () -> {
                Optional jobInfoDOOptional = this.jobInfoRepository.findById((Object)jobId);
                return jobInfoDOOptional.map(JobInfoDO::getJobName).orElse("");
            });
        }
        catch (Exception e) {
            log.error("[CacheService] getJobName for {} failed.", (Object)jobId, (Object)e);
            return null;
        }
    }

    public String getWorkflowName(Long workflowId) {
        try {
            return (String)this.workflowId2WorkflowNameCache.get((Object)workflowId, () -> {
                Optional jobInfoDOOptional = this.workflowInfoRepository.findById((Object)workflowId);
                return jobInfoDOOptional.map(WorkflowInfoDO::getWfName).orElse("");
            });
        }
        catch (Exception e) {
            log.error("[CacheService] getWorkflowName for {} failed.", (Object)workflowId, (Object)e);
            return null;
        }
    }

    public Long getAppIdByInstanceId(Long instanceId) {
        try {
            return (Long)this.instanceId2AppId.get((Object)instanceId, () -> {
                try {
                    InstanceInfoDO instanceLog = this.instanceInfoRepository.findByInstanceId(instanceId.longValue());
                    if (instanceLog != null) {
                        return instanceLog.getAppId();
                    }
                }
                catch (Exception e) {
                    log.error("[CacheService] getAppId for instanceId:{} failed.", (Object)instanceId, (Object)e);
                }
                return null;
            });
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Long getAppIdByJobId(Long jobId) {
        try {
            return (Long)this.jobId2AppId.get((Object)jobId, () -> {
                try {
                    Optional jobInfoDOOptional = this.jobInfoRepository.findById((Object)jobId);
                    return jobInfoDOOptional.map(JobInfoDO::getAppId).orElse(null);
                }
                catch (Exception e) {
                    log.error("[CacheService] getAppId for job:{} failed.", (Object)jobId, (Object)e);
                    return null;
                }
            });
        }
        catch (Exception exception) {
            return null;
        }
    }
}

