/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.core.validator;

import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import tech.powerjob.common.enums.WorkflowNodeType;
import tech.powerjob.common.exception.PowerJobException;
import tech.powerjob.common.model.PEWorkflowDAG;
import tech.powerjob.server.core.validator.NodeValidator;
import tech.powerjob.server.core.workflow.algorithm.WorkflowDAG;
import tech.powerjob.server.persistence.remote.model.WorkflowNodeInfoDO;

@Component
public class DecisionNodeValidator
implements NodeValidator {
    private static final Logger log = LoggerFactory.getLogger(DecisionNodeValidator.class);

    @Override
    public void complexValidate(WorkflowNodeInfoDO node, WorkflowDAG dag) {
        WorkflowDAG.Node nodeWrapper = dag.getNode(node.getId());
        Collection<PEWorkflowDAG.Edge> edges = nodeWrapper.getSuccessorEdgeMap().values();
        if (edges.size() != 2) {
            throw new PowerJobException("DecisionNode\u2018s out-degree must be 2,node name : " + node.getNodeName());
        }
        boolean containFalse = false;
        boolean containTrue = false;
        for (PEWorkflowDAG.Edge edge : edges) {
            if (!DecisionNodeValidator.isValidBooleanStr(edge.getProperty())) {
                throw new PowerJobException("Illegal property of DecisionNode\u2018s out-degree edge,node name : " + node.getNodeName());
            }
            boolean b = Boolean.parseBoolean(edge.getProperty());
            if (b) {
                containTrue = true;
                continue;
            }
            containFalse = true;
        }
        if (!containFalse || !containTrue) {
            throw new PowerJobException("Illegal property of DecisionNode\u2018s out-degree edge,node name : " + node.getNodeName());
        }
    }

    @Override
    public void simpleValidate(WorkflowNodeInfoDO node) {
        String nodeParams = node.getNodeParams();
        if (StringUtils.isBlank((CharSequence)nodeParams)) {
            throw new PowerJobException("DecisionNode\u2018s param must be not null,node name : " + node.getNodeName());
        }
    }

    public static boolean isValidBooleanStr(String str) {
        return StringUtils.equalsIgnoreCase((CharSequence)str.trim(), (CharSequence)"true") || StringUtils.equalsIgnoreCase((CharSequence)str.trim(), (CharSequence)"false");
    }

    @Override
    public WorkflowNodeType matchingType() {
        return WorkflowNodeType.DECISION;
    }
}

