/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.core.uid;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import tech.powerjob.server.core.uid.SnowFlakeIdGenerator;
import tech.powerjob.server.remote.server.self.ServerInfoService;

@Service
public class IdGenerateService {
    private static final Logger log = LoggerFactory.getLogger(IdGenerateService.class);
    private final SnowFlakeIdGenerator snowFlakeIdGenerator;
    private static final int DATA_CENTER_ID = 0;

    public IdGenerateService(ServerInfoService serverInfoService) {
        long id = serverInfoService.fetchCurrentServerInfo().getId();
        this.snowFlakeIdGenerator = new SnowFlakeIdGenerator(0L, id);
        log.info("[IdGenerateService] initialize IdGenerateService successfully, ID:{}", (Object)id);
    }

    public long allocate() {
        return this.snowFlakeIdGenerator.nextId();
    }
}

