/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.server.core.validator;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import tech.powerjob.common.enums.SwitchableStatus;
import tech.powerjob.common.enums.WorkflowNodeType;
import tech.powerjob.common.exception.PowerJobException;
import tech.powerjob.server.core.validator.NodeValidator;
import tech.powerjob.server.core.workflow.algorithm.WorkflowDAG;
import tech.powerjob.server.persistence.remote.model.JobInfoDO;
import tech.powerjob.server.persistence.remote.model.WorkflowNodeInfoDO;
import tech.powerjob.server.persistence.remote.repository.JobInfoRepository;

@Component
public class JobNodeValidator
implements NodeValidator {
    private static final Logger log = LoggerFactory.getLogger(JobNodeValidator.class);
    private final JobInfoRepository jobInfoRepository;

    @Override
    public void complexValidate(WorkflowNodeInfoDO node, WorkflowDAG dag) {
    }

    @Override
    public void simpleValidate(WorkflowNodeInfoDO node) {
        JobInfoDO job = (JobInfoDO)this.jobInfoRepository.findById((Object)node.getJobId()).orElseThrow(() -> new PowerJobException("Illegal job node,specified job is not exist,node name : " + node.getNodeName()));
        if (job.getStatus().intValue() == SwitchableStatus.DELETED.getV()) {
            throw new PowerJobException("Illegal job node,specified job has been deleted,node name : " + node.getNodeName());
        }
    }

    @Override
    public WorkflowNodeType matchingType() {
        return WorkflowNodeType.JOB;
    }

    public JobNodeValidator(JobInfoRepository jobInfoRepository) {
        this.jobInfoRepository = jobInfoRepository;
    }
}

