/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.unit;

import java.util.Map;
import java.util.Objects;
import javax.measure.Dimension;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import tech.units.indriya.AbstractUnit;
import tech.units.indriya.function.AbstractConverter;
import tech.units.indriya.unit.UnitDimension;

public final class BaseUnit<Q extends Quantity<Q>>
extends AbstractUnit<Q> {
    private static final long serialVersionUID = 1721629233768215930L;
    private final Dimension dimension;

    public BaseUnit(String symbol, Dimension dimension) {
        super(symbol);
        this.dimension = dimension;
    }

    public BaseUnit(String symbol) {
        super(symbol);
        this.dimension = UnitDimension.NONE;
    }

    public BaseUnit(String symbol, String name) {
        this(symbol);
        this.name = name;
    }

    @Override
    public Unit<Q> toSystemUnit() {
        return this;
    }

    @Override
    public UnitConverter getSystemConverter() throws UnsupportedOperationException {
        return AbstractConverter.IDENTITY;
    }

    @Override
    public Dimension getDimension() {
        return this.dimension;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getSymbol() == null ? 0 : this.getSymbol().hashCode());
        result = result + 31 * result + (this.dimension == null ? 0 : this.dimension.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BaseUnit other = (BaseUnit)obj;
        return Objects.equals(this.dimension, other.dimension) && Objects.equals(this.getSymbol(), other.getSymbol());
    }

    @Override
    public Map<? extends AbstractUnit<Q>, Integer> getBaseUnits() {
        return null;
    }
}

