/*
 * Decompiled with CFR 0.152.
 */
package tk.mybatis.mapper.provider.base;

import java.util.ArrayList;
import java.util.Set;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.scripting.xmltags.IfSqlNode;
import org.apache.ibatis.scripting.xmltags.MixedSqlNode;
import org.apache.ibatis.scripting.xmltags.SqlNode;
import org.apache.ibatis.scripting.xmltags.StaticTextSqlNode;
import org.apache.ibatis.scripting.xmltags.TrimSqlNode;
import org.apache.ibatis.scripting.xmltags.VarDeclSqlNode;
import tk.mybatis.mapper.entity.EntityColumn;
import tk.mybatis.mapper.mapperhelper.EntityHelper;
import tk.mybatis.mapper.mapperhelper.MapperHelper;
import tk.mybatis.mapper.mapperhelper.MapperTemplate;
import tk.mybatis.mapper.util.StringUtil;

public class BaseInsertProvider
extends MapperTemplate {
    public BaseInsertProvider(Class<?> mapperClass, MapperHelper mapperHelper) {
        super(mapperClass, mapperHelper);
    }

    public SqlNode insert(MappedStatement ms) {
        Class<?> entityClass = this.getEntityClass(ms);
        ArrayList<Object> sqlNodes = new ArrayList<Object>();
        sqlNodes.add(new StaticTextSqlNode("INSERT INTO "));
        sqlNodes.add(this.getDynamicTableNameNode(entityClass));
        Set<EntityColumn> columnList = EntityHelper.getColumns(entityClass);
        Boolean hasIdentityKey = false;
        for (EntityColumn column : columnList) {
            if (StringUtil.isNotEmpty(column.getSequenceName())) continue;
            if (column.isIdentity()) {
                sqlNodes.add(new VarDeclSqlNode(column.getProperty() + "_cache", column.getProperty()));
                if (hasIdentityKey.booleanValue()) {
                    if (column.getGenerator() != null && column.getGenerator().equals("JDBC")) continue;
                    throw new RuntimeException(ms.getId() + "\u5bf9\u5e94\u7684\u5b9e\u4f53\u7c7b" + entityClass.getCanonicalName() + "\u4e2d\u5305\u542b\u591a\u4e2aMySql\u7684\u81ea\u52a8\u589e\u957f\u5217,\u6700\u591a\u53ea\u80fd\u6709\u4e00\u4e2a!");
                }
                this.newSelectKeyMappedStatement(ms, column);
                hasIdentityKey = true;
                continue;
            }
            if (!column.isUuid()) continue;
            sqlNodes.add(new VarDeclSqlNode(column.getProperty() + "_bind", this.getUUID()));
        }
        sqlNodes.add(new StaticTextSqlNode("(" + EntityHelper.getAllColumns(entityClass) + ")"));
        ArrayList<SqlNode> ifNodes = new ArrayList<SqlNode>();
        for (EntityColumn column : columnList) {
            if (column.isIdentity()) {
                ifNodes.add(this.getIfCacheNotNull(column, (SqlNode)new StaticTextSqlNode("#{" + column.getProperty() + "_cache },")));
            } else {
                ifNodes.add(this.getIfNotNull(column, (SqlNode)new StaticTextSqlNode(column.getColumnHolder() + ",")));
            }
            if (StringUtil.isNotEmpty(column.getSequenceName())) {
                ifNodes.add(this.getIfIsNull(column, (SqlNode)new StaticTextSqlNode(this.getSeqNextVal(column) + " ,")));
                continue;
            }
            if (column.isIdentity()) {
                ifNodes.add(this.getIfCacheIsNull(column, (SqlNode)new StaticTextSqlNode(column.getColumnHolder() + ",")));
                continue;
            }
            if (column.isUuid()) {
                ifNodes.add(this.getIfIsNull(column, (SqlNode)new StaticTextSqlNode("#{" + column.getProperty() + "_bind },")));
                continue;
            }
            ifNodes.add(this.getIfIsNull(column, (SqlNode)new StaticTextSqlNode(column.getColumnHolder() + ",")));
        }
        sqlNodes.add(new TrimSqlNode(ms.getConfiguration(), (SqlNode)new MixedSqlNode(ifNodes), "VALUES (", null, ")", ","));
        return new MixedSqlNode(sqlNodes);
    }

    public SqlNode insertSelective(MappedStatement ms) {
        Class<?> entityClass = this.getEntityClass(ms);
        ArrayList<Object> sqlNodes = new ArrayList<Object>();
        sqlNodes.add(new StaticTextSqlNode("INSERT INTO "));
        sqlNodes.add(this.getDynamicTableNameNode(entityClass));
        Set<EntityColumn> columnList = EntityHelper.getColumns(entityClass);
        ArrayList<Object> ifNodes = new ArrayList<Object>();
        Boolean hasIdentityKey = false;
        for (EntityColumn column : columnList) {
            if (StringUtil.isNotEmpty(column.getSequenceName())) {
                ifNodes.add(new StaticTextSqlNode(column.getColumn() + ","));
                continue;
            }
            if (column.isIdentity()) {
                sqlNodes.add(new VarDeclSqlNode(column.getProperty() + "_cache", column.getProperty()));
                if (hasIdentityKey.booleanValue()) {
                    if (column.getGenerator() != null && column.getGenerator().equals("JDBC")) continue;
                    throw new RuntimeException(ms.getId() + "\u5bf9\u5e94\u7684\u5b9e\u4f53\u7c7b" + entityClass.getCanonicalName() + "\u4e2d\u5305\u542b\u591a\u4e2aMySql\u7684\u81ea\u52a8\u589e\u957f\u5217,\u6700\u591a\u53ea\u80fd\u6709\u4e00\u4e2a!");
                }
                this.newSelectKeyMappedStatement(ms, column);
                hasIdentityKey = true;
                ifNodes.add(new StaticTextSqlNode(column.getColumn() + ","));
                continue;
            }
            if (column.isUuid()) {
                sqlNodes.add(new VarDeclSqlNode(column.getProperty() + "_bind", this.getUUID()));
                ifNodes.add(new StaticTextSqlNode(column.getColumn() + ","));
                continue;
            }
            ifNodes.add(this.getIfNotNull(column, (SqlNode)new StaticTextSqlNode(column.getColumn() + ",")));
        }
        sqlNodes.add(new TrimSqlNode(ms.getConfiguration(), (SqlNode)new MixedSqlNode(ifNodes), "(", null, ")", ","));
        ifNodes = new ArrayList();
        for (EntityColumn column : columnList) {
            if (column.isIdentity()) {
                ifNodes.add(new IfSqlNode((SqlNode)new StaticTextSqlNode("#{" + column.getProperty() + "_cache },"), column.getProperty() + "_cache != null "));
            } else {
                ifNodes.add(new IfSqlNode((SqlNode)new StaticTextSqlNode(column.getColumnHolder() + ","), column.getProperty() + " != null "));
            }
            if (StringUtil.isNotEmpty(column.getSequenceName())) {
                ifNodes.add(this.getIfIsNull(column, (SqlNode)new StaticTextSqlNode(this.getSeqNextVal(column) + " ,")));
                continue;
            }
            if (column.isIdentity()) {
                ifNodes.add(this.getIfCacheIsNull(column, (SqlNode)new StaticTextSqlNode(column.getColumnHolder() + ",")));
                continue;
            }
            if (!column.isUuid()) continue;
            ifNodes.add(this.getIfIsNull(column, (SqlNode)new StaticTextSqlNode("#{" + column.getProperty() + "_bind },")));
        }
        sqlNodes.add(new TrimSqlNode(ms.getConfiguration(), (SqlNode)new MixedSqlNode(ifNodes), "VALUES (", null, ")", ","));
        return new MixedSqlNode(sqlNodes);
    }
}

