/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.web.converter;

import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.support.config.FastJsonConfig;
import com.alibaba.fastjson.support.spring.FastJsonHttpMessageConverter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;

public class FastJsonConverterFactory {
    private static final Logger log = LoggerFactory.getLogger(FastJsonConverterFactory.class);
    private FastJsonHttpMessageConverter fastJsonHttpMessageConverter = null;
    private FastJsonConfig fastJsonConfig = null;
    private Set<MediaType> supportedMediaTypes = new HashSet<MediaType>();

    private FastJsonConverterFactory() {
        log.debug("Init fast json http message converter...");
        this.fastJsonHttpMessageConverter = new FastJsonHttpMessageConverter();
        this.supportedMediaTypes.add(MediaType.parseMediaType((String)"text/html;charset=UTF-8"));
        this.supportedMediaTypes.add(MediaType.APPLICATION_JSON_UTF8);
        this.fastJsonHttpMessageConverter.setSupportedMediaTypes(new ArrayList<MediaType>(this.supportedMediaTypes));
        this.fastJsonConfig = this.fastJsonHttpMessageConverter.getFastJsonConfig();
        this.fastJsonConfig.setDateFormat("yyyy-MM-dd HH:mm:ss");
    }

    public static FastJsonConverterFactory build() {
        log.debug("Init fast json converter factory...");
        return new FastJsonConverterFactory();
    }

    public FastJsonConverterFactory setDateFormat(String dateFormat) {
        if (StringUtils.isNotEmpty((CharSequence)dateFormat)) {
            this.fastJsonConfig.setDateFormat(dateFormat);
            log.debug("Set fastJson config date format...");
        }
        return this;
    }

    public FastJsonConverterFactory addSerializerFeature(SerializerFeature ... serializerFeatures) {
        if (ArrayUtils.isNotEmpty((Object[])serializerFeatures)) {
            Object[] oldSerializerFeatures = this.fastJsonConfig.getSerializerFeatures();
            SerializerFeature[] newSerializerFeatures = (SerializerFeature[])ArrayUtils.addAll((Object[])oldSerializerFeatures, (Object[])serializerFeatures);
            this.fastJsonConfig.setSerializerFeatures(newSerializerFeatures);
            log.debug("Add fastJson config serializerFeatures...");
        }
        return this;
    }

    public FastJsonConverterFactory addSerializerFeature(List<SerializerFeature> serializerFeatures) {
        if (CollectionUtils.isNotEmpty(serializerFeatures)) {
            this.addSerializerFeature(serializerFeatures.toArray(new SerializerFeature[serializerFeatures.size()]));
        }
        return this;
    }

    public FastJsonConverterFactory addSupportedMediaType(String mediaType) {
        if (StringUtils.isNotEmpty((CharSequence)mediaType)) {
            try {
                this.addSupportedMediaType(MediaType.parseMediaType((String)mediaType));
            }
            catch (Exception e) {
                log.warn("This string{} can not parse to a MediaType", (Object)mediaType);
            }
        }
        return this;
    }

    public FastJsonConverterFactory addSupportedMediaType(MediaType mediaType) {
        if (mediaType != null) {
            this.supportedMediaTypes.add(mediaType);
            this.refreshSupportedMediaTypes();
            log.debug("Add fast json http message converter supported media type...");
        }
        return this;
    }

    public FastJsonConverterFactory addSupportedMediaType(List<MediaType> mediaTypes) {
        if (CollectionUtils.isNotEmpty(mediaTypes)) {
            this.supportedMediaTypes.addAll(this.supportedMediaTypes);
            this.refreshSupportedMediaTypes();
        }
        return this;
    }

    private void refreshSupportedMediaTypes() {
        this.fastJsonHttpMessageConverter.setSupportedMediaTypes(new ArrayList<MediaType>(this.supportedMediaTypes));
    }

    public FastJsonHttpMessageConverter get() {
        return this.fastJsonHttpMessageConverter;
    }
}

