/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.web.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.lshaci.framework.common.exception.BaseException;
import top.lshaci.framework.web.enums.ResponseContentType;
import top.lshaci.framework.web.exception.WebBaseException;

public class DownloadUtils {
    private static final Logger log = LoggerFactory.getLogger(DownloadUtils.class);
    public static int cacheSize;

    public static void download(String downloadName, ResponseContentType contentType, ByteArrayOutputStream outputStream, HttpServletResponse response) {
        try (ByteArrayInputStream fileInputStream = new ByteArrayInputStream(outputStream.toByteArray());
             ServletOutputStream os = response.getOutputStream();){
            DownloadUtils.writeFile(downloadName, contentType, response, fileInputStream, os);
        }
        catch (Exception e) {
            log.error("\u5bfc\u51fa[" + downloadName + "]\u5931\u8d25", (Throwable)e);
            throw new WebBaseException("\u5bfc\u51fa[" + downloadName + "]\u5931\u8d25", e);
        }
    }

    public static void download(String downloadName, ResponseContentType contentType, FileInputStream fileInputStream, HttpServletResponse response) {
        try (ServletOutputStream os = response.getOutputStream();){
            DownloadUtils.writeFile(downloadName, contentType, response, fileInputStream, os);
        }
        catch (Exception e) {
            log.error("\u5bfc\u51fa[" + downloadName + "]\u5931\u8d25", (Throwable)e);
            throw new WebBaseException("\u5bfc\u51fa[" + downloadName + "]\u5931\u8d25", e);
        }
        finally {
            try {
                fileInputStream.close();
            }
            catch (IOException e) {
                log.warn("Ignore the resource close exception", (Throwable)e);
            }
        }
    }

    public static void download(String downloadName, ResponseContentType contentType, String filePath, HttpServletResponse response) {
        try (FileInputStream fileInputStream = new FileInputStream(filePath);
             ServletOutputStream os = response.getOutputStream();){
            DownloadUtils.writeFile(downloadName, contentType, response, fileInputStream, os);
        }
        catch (Exception e) {
            log.error("\u5bfc\u51fa[" + downloadName + "]\u5931\u8d25", (Throwable)e);
            throw new WebBaseException("\u5bfc\u51fa[" + downloadName + "]\u5931\u8d25", e);
        }
    }

    private static void writeFile(String downloadName, ResponseContentType contentType, HttpServletResponse response, InputStream fileInputStream, ServletOutputStream os) throws IOException {
        int length;
        response.setHeader("Content-disposition", "attachment;filename=" + URLEncoder.encode(downloadName, "UTF-8"));
        if (StringUtils.isBlank((CharSequence)downloadName)) {
            throw new BaseException("The download file name must not be empty!");
        }
        if (contentType != null) {
            response.setContentType(contentType.getName());
        }
        byte[] b = new byte[cacheSize];
        while ((length = fileInputStream.read(b)) > 0) {
            os.write(b, 0, length);
        }
    }
}

