/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.web.utils;

import com.alibaba.fastjson.JSON;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.lshaci.framework.web.exception.WebBaseException;
import top.lshaci.framework.web.utils.HttpSessionUtils;

public class SessionUserUtils {
    private static final Logger log = LoggerFactory.getLogger(SessionUserUtils.class);
    public static final String USER_IN_SESSION = SessionUserUtils.class.getName() + ".userInSession";
    public static final String USER_ROLE_IN_SESSION = SessionUserUtils.class.getName() + ".userRoleInSession";

    public static void setUserInSession(Object user) {
        Objects.requireNonNull(user, "The user must not be null!");
        String jsonUser = JSON.toJSONString((Object)user);
        HttpSessionUtils.setAttribute(USER_IN_SESSION, jsonUser);
    }

    public static String getUserInSession() {
        return (String)HttpSessionUtils.getAttribute(USER_IN_SESSION);
    }

    public static <T> T getUserInSession(Class<T> userType) {
        String userInSession = SessionUserUtils.getUserInSession();
        try {
            return (T)JSON.parseObject((String)userInSession, userType);
        }
        catch (Exception e) {
            log.error("The user type error!", (Throwable)e);
            throw new WebBaseException("The user type error!", e);
        }
    }

    public static void setUserRoleInSession(String role) {
        if (StringUtils.isNotBlank((CharSequence)role)) {
            HttpSessionUtils.setAttribute(USER_ROLE_IN_SESSION, role.trim());
        }
    }

    public static String getUserRoleInSession() {
        return (String)HttpSessionUtils.getAttribute(USER_ROLE_IN_SESSION);
    }
}

