/*
 * Decompiled with CFR 0.152.
 */
package top.lshaci.framework.web.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;
import top.lshaci.framework.web.exception.WebBaseException;

public class UploadUtils {
    private static final Logger log = LoggerFactory.getLogger(UploadUtils.class);

    public static void save(String filePath, String saveFileName, MultipartFile file) {
        Objects.requireNonNull(file, "The file must not be null!");
        if (StringUtils.isBlank((CharSequence)filePath) || StringUtils.isBlank((CharSequence)saveFileName)) {
            throw new WebBaseException("The file path or save file name is empty!");
        }
        File saveFile = new File(filePath, saveFileName);
        if (!saveFile.getParentFile().exists()) {
            saveFile.getParentFile().mkdirs();
        }
        try (InputStream is = file.getInputStream();
             FileOutputStream os = new FileOutputStream(saveFile);){
            int length;
            byte[] b = new byte[2048];
            while ((length = is.read(b)) > 0) {
                os.write(b, 0, length);
            }
        }
        catch (IOException | IllegalStateException e) {
            log.error("Failed to save file!", (Throwable)e);
            throw new WebBaseException("Failed to save file!", e);
        }
    }
}

