/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.webmagic.downloader;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.http.annotation.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.codecraft.webmagic.Page;
import us.codecraft.webmagic.Request;
import us.codecraft.webmagic.Task;
import us.codecraft.webmagic.downloader.AbstractDownloader;
import us.codecraft.webmagic.selector.PlainText;
import us.codecraft.webmagic.selector.Selectable;

@ThreadSafe
public class PhantomJSDownloader
extends AbstractDownloader {
    private static Logger logger = LoggerFactory.getLogger(PhantomJSDownloader.class);
    private static String crawlJsPath;
    private static String phantomJsCommand;
    private int retryNum;
    private int threadNum;

    public PhantomJSDownloader() {
        this.initPhantomjsCrawlPath();
    }

    public PhantomJSDownloader(String phantomJsCommand) {
        this.initPhantomjsCrawlPath();
        PhantomJSDownloader.phantomJsCommand = phantomJsCommand;
    }

    public PhantomJSDownloader(String phantomJsCommand, String crawlJsPath) {
        PhantomJSDownloader.phantomJsCommand = phantomJsCommand;
        PhantomJSDownloader.crawlJsPath = crawlJsPath;
    }

    private void initPhantomjsCrawlPath() {
        crawlJsPath = new File(((Object)((Object)this)).getClass().getResource("/").getPath()).getPath() + System.getProperty("file.separator") + "crawl.js ";
    }

    public Page download(Request request, Task task) {
        String content;
        if (logger.isInfoEnabled()) {
            logger.info("downloading page: " + request.getUrl());
        }
        if ((content = this.getPage(request)).contains("HTTP request failed")) {
            for (int i = 1; i <= this.getRetryNum() && (content = this.getPage(request)).contains("HTTP request failed"); ++i) {
            }
            if (content.contains("HTTP request failed")) {
                Page page = new Page();
                page.setRequest(request);
                return page;
            }
        }
        Page page = new Page();
        page.setRawText(content);
        page.setUrl((Selectable)new PlainText(request.getUrl()));
        page.setRequest(request);
        page.setStatusCode(200);
        return page;
    }

    public void setThread(int threadNum) {
        this.threadNum = threadNum;
    }

    protected String getPage(Request request) {
        try {
            String line;
            String url = request.getUrl();
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec(phantomJsCommand + " " + crawlJsPath + " " + url);
            InputStream is = process.getInputStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            StringBuffer stringBuffer = new StringBuffer();
            while ((line = br.readLine()) != null) {
                stringBuffer.append(line).append("\n");
            }
            return stringBuffer.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public int getRetryNum() {
        return this.retryNum;
    }

    public PhantomJSDownloader setRetryNum(int retryNum) {
        this.retryNum = retryNum;
        return this;
    }

    static {
        phantomJsCommand = "phantomjs";
    }
}

