/*
 * Decompiled with CFR 0.152.
 */
package wicket.authentication;

import wicket.Component;
import wicket.ISessionFactory;
import wicket.Page;
import wicket.RestartResponseAtInterceptPageException;
import wicket.Session;
import wicket.WicketRuntimeException;
import wicket.authentication.AuthenticatedWebSession;
import wicket.authorization.IAuthorizationStrategy;
import wicket.authorization.IUnauthorizedComponentInstantiationListener;
import wicket.authorization.UnauthorizedInstantiationException;
import wicket.authorization.strategies.role.IRoleCheckingStrategy;
import wicket.authorization.strategies.role.RoleAuthorizationStrategy;
import wicket.authorization.strategies.role.Roles;
import wicket.markup.html.WebPage;
import wicket.protocol.http.WebApplication;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AuthenticatedWebApplication
extends WebApplication
implements IRoleCheckingStrategy,
IUnauthorizedComponentInstantiationListener {
    private final Class<? extends AuthenticatedWebSession> webSessionClass = this.getWebSessionClass();

    protected void init() {
        super.init();
        this.getSecuritySettings().setAuthorizationStrategy((IAuthorizationStrategy)new RoleAuthorizationStrategy(this));
        this.getSecuritySettings().setUnauthorizedComponentInstantiationListener((IUnauthorizedComponentInstantiationListener)this);
    }

    @Override
    public final boolean hasAnyRole(Roles roles) {
        Roles sessionRoles = AuthenticatedWebSession.get().getRoles();
        return sessionRoles != null && sessionRoles.hasAnyRole(roles);
    }

    public final void onUnauthorizedInstantiation(Component component) {
        if (component instanceof Page) {
            if (!AuthenticatedWebSession.get().isSignedIn()) {
                throw new RestartResponseAtInterceptPageException(this.getSignInPageClass());
            }
        } else {
            throw new UnauthorizedInstantiationException(component.getClass());
        }
        this.onUnauthorizedPage((Page)component);
    }

    protected final ISessionFactory getSessionFactory() {
        return new ISessionFactory(){
            private static final long serialVersionUID = 1L;

            public Session newSession() {
                try {
                    return (Session)AuthenticatedWebApplication.this.webSessionClass.getDeclaredConstructor(AuthenticatedWebApplication.class).newInstance(AuthenticatedWebApplication.this);
                }
                catch (Exception e) {
                    throw new WicketRuntimeException("Unable to instantiate web session class " + AuthenticatedWebApplication.this.webSessionClass, (Throwable)e);
                }
            }
        };
    }

    protected abstract Class<? extends AuthenticatedWebSession> getWebSessionClass();

    protected abstract Class<? extends WebPage> getSignInPageClass();

    protected void onUnauthorizedPage(Page page) {
        throw new UnauthorizedInstantiationException(page.getClass());
    }
}

