/*
 * Decompiled with CFR 0.152.
 */
package wicket.authorization.strategies.role.metadata;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import wicket.Component;
import wicket.authorization.strategies.role.Roles;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class InstantiationPermissions
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<Class<? extends Component>, Roles> rolesForComponentClass = new HashMap<Class<? extends Component>, Roles>();

    InstantiationPermissions() {
    }

    public final void authorize(Class<? extends Component> componentClass, Roles rolesToAdd) {
        if (componentClass == null) {
            throw new IllegalArgumentException("Argument componentClass cannot be null");
        }
        if (rolesToAdd == null) {
            throw new IllegalArgumentException("Argument rolesToadd cannot be null");
        }
        Roles roles = this.rolesForComponentClass.get(componentClass);
        if (roles == null) {
            roles = new Roles();
            this.rolesForComponentClass.put(componentClass, roles);
        }
        roles.addAll(rolesToAdd);
    }

    public final void authorizeAll(Class<? extends Component> componentClass) {
        if (componentClass == null) {
            throw new IllegalArgumentException("Argument componentClass cannot be null");
        }
        this.rolesForComponentClass.remove(componentClass);
    }

    public final Roles authorizedRoles(Class<? extends Component> componentClass) {
        if (componentClass == null) {
            throw new IllegalArgumentException("Argument componentClass cannot be null");
        }
        return this.rolesForComponentClass.get(componentClass);
    }

    public final void unauthorize(Class<? extends Component> componentClass, Roles rolesToRemove) {
        if (componentClass == null) {
            throw new IllegalArgumentException("Argument componentClass cannot be null");
        }
        if (rolesToRemove == null) {
            throw new IllegalArgumentException("Argument rolesToRemove cannot be null");
        }
        Roles roles = this.rolesForComponentClass.get(componentClass);
        if (roles != null) {
            roles.removeAll(rolesToRemove);
        }
        if (roles.size() == 0) {
            roles.add("wicket:NO_ROLE");
        }
    }
}

