/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss;

import com.aliyun.oss.ClientException;
import com.aliyun.oss.common.comm.Protocol;
import com.aliyun.oss.common.utils.ResourceManager;
import com.aliyun.oss.common.utils.VersionInfoUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ClientConfiguration {
    private static final String DEFAULT_USER_AGENT = VersionInfoUtils.getDefaultUserAgent();
    private static final int DEFAULT_MAX_RETRIES = 3;
    public static final int DEFAULT_CONNECTION_TIMEOUT = 50000;
    public static final int DEFAULT_SOCKET_TIMEOUT = 50000;
    public static final int DEFAULT_MAX_CONNECTIONS = 1024;
    public static final long DEFAULT_CONNECTION_TTL = -1L;
    public static final boolean DEFAULT_USE_REAPER = true;
    public static final String DEFAULT_CNAME_EXCLUDE_LIST = "aliyuncs.com,aliyun-inc.com,aliyun.com";
    private String userAgent = DEFAULT_USER_AGENT;
    private int maxErrorRetry = 3;
    private int connectionTimeout = 50000;
    private int socketTimeout = 50000;
    private int maxConnections = 1024;
    private long connectionTTL = -1L;
    private boolean useReaper = true;
    private Protocol protocol = Protocol.HTTP;
    private String proxyHost = null;
    private int proxyPort = -1;
    private String proxyUsername = null;
    private String proxyPassword = null;
    private String proxyDomain = null;
    private String proxyWorkstation = null;
    private boolean supportCname = true;
    private List<String> cnameExcludeList = new ArrayList<String>();
    private Lock rlock = new ReentrantLock();
    private boolean sldEnabled = false;

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) throws ClientException {
        if (proxyPort <= 0) {
            throw new ClientException(ResourceManager.getInstance("common").getString("ParameterIsInvalid"), null);
        }
        this.proxyPort = proxyPort;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public String getProxyDomain() {
        return this.proxyDomain;
    }

    public void setProxyDomain(String proxyDomain) {
        this.proxyDomain = proxyDomain;
    }

    public String getProxyWorkstation() {
        return this.proxyWorkstation;
    }

    public void setProxyWorkstation(String proxyWorkstation) {
        this.proxyWorkstation = proxyWorkstation;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public int getMaxErrorRetry() {
        return this.maxErrorRetry;
    }

    public void setMaxErrorRetry(int maxErrorRetry) {
        this.maxErrorRetry = maxErrorRetry;
    }

    public long getConnectionTTL() {
        return this.connectionTTL;
    }

    public void setConnectionTTL(long connectionTTL) {
        this.connectionTTL = connectionTTL;
    }

    public boolean isUseReaper() {
        return this.useReaper;
    }

    public void setUseReaper(boolean useReaper) {
        this.useReaper = useReaper;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    public List<String> getCnameExcludeList() {
        if (this.cnameExcludeList.size() == 0) {
            this.rlock.lock();
            if (this.cnameExcludeList.size() == 0) {
                ClientConfiguration.AppendDefaultExcludeList(this.cnameExcludeList);
            }
            this.rlock.unlock();
        }
        return Collections.unmodifiableList(this.cnameExcludeList);
    }

    public void setCnameExcludeList(List<String> cnameExcludeList) {
        if (cnameExcludeList == null) {
            throw new IllegalArgumentException("cname exclude list should not be null.");
        }
        this.cnameExcludeList.clear();
        for (String excl : cnameExcludeList) {
            if (excl.trim().isEmpty()) continue;
            this.cnameExcludeList.add(excl);
        }
        ClientConfiguration.AppendDefaultExcludeList(this.cnameExcludeList);
    }

    private static void AppendDefaultExcludeList(List<String> excludeList) {
        String[] excludes;
        String[] stringArray = excludes = DEFAULT_CNAME_EXCLUDE_LIST.split(",");
        int n = excludes.length;
        int n2 = 0;
        while (n2 < n) {
            String excl = stringArray[n2];
            if (!excl.trim().isEmpty() && !excludeList.contains(excl)) {
                excludeList.add(excl.trim().toLowerCase());
            }
            ++n2;
        }
    }

    public boolean isSupportCname() {
        return this.supportCname;
    }

    public ClientConfiguration setSupportCname(boolean supportCname) {
        this.supportCname = supportCname;
        return this;
    }

    public boolean isSLDEnabled() {
        return this.sldEnabled;
    }

    public ClientConfiguration setSLDEnabled(boolean enabled) {
        this.sldEnabled = enabled;
        return this;
    }
}

