/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.integrationtests;

import com.aliyun.oss.OSSException;
import com.aliyun.oss.integrationtests.TestBase;
import com.aliyun.oss.integrationtests.TestUtils;
import com.aliyun.oss.model.AppendObjectRequest;
import com.aliyun.oss.model.AppendObjectResult;
import com.aliyun.oss.model.CannedAccessControlList;
import com.aliyun.oss.model.CompleteMultipartUploadRequest;
import com.aliyun.oss.model.CompleteMultipartUploadResult;
import com.aliyun.oss.model.CopyObjectRequest;
import com.aliyun.oss.model.CopyObjectResult;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.ObjectAcl;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.ObjectPermission;
import com.aliyun.oss.model.PartETag;
import com.aliyun.oss.model.PutObjectResult;
import com.aliyun.oss.model.UploadPartRequest;
import com.aliyun.oss.model.UploadPartResult;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import junit.framework.Assert;
import org.junit.Test;

public class ObjectAclTest
extends TestBase {
    private static final CannedAccessControlList[] ACLS = new CannedAccessControlList[]{CannedAccessControlList.Default, CannedAccessControlList.Private, CannedAccessControlList.PublicRead, CannedAccessControlList.PublicReadWrite};

    @Test
    public void testNormalSetObjectAcl() {
        String key = "normal-set-object-acl";
        long inputStreamLength = 131072L;
        try {
            InputStream instream = TestUtils.genFixedLengthInputStream(131072L);
            secondClient.putObject(bucketName, "normal-set-object-acl", instream);
            CannedAccessControlList[] cannedAccessControlListArray = ACLS;
            int n = ACLS.length;
            int n2 = 0;
            while (n2 < n) {
                CannedAccessControlList acl = cannedAccessControlListArray[n2];
                secondClient.setObjectAcl(bucketName, "normal-set-object-acl", acl);
                ObjectAcl returnedAcl = secondClient.getObjectAcl(bucketName, "normal-set-object-acl");
                Assert.assertEquals((String)acl.toString(), (String)returnedAcl.getPermission().toString());
                OSSObject object = secondClient.getObject(bucketName, "normal-set-object-acl");
                Assert.assertEquals((long)131072L, (long)object.getObjectMetadata().getContentLength());
                object.getObjectContent().close();
                ++n2;
            }
            secondClient.setObjectAcl(bucketName, "normal-set-object-acl", CannedAccessControlList.Default);
            ObjectAcl returnedAcl = secondClient.getObjectAcl(bucketName, "normal-set-object-acl");
            Assert.assertEquals((Object)((Object)ObjectPermission.Default), (Object)((Object)returnedAcl.getPermission()));
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testUnormalSetObjectAcl() {
        try {
            String nonexistentObject = "unormal-set-object-acl";
            try {
                secondClient.setObjectAcl(bucketName, "unormal-set-object-acl", CannedAccessControlList.Private);
                Assert.fail((String)"Set object acl should not be successful");
            }
            catch (OSSException e) {
                Assert.assertEquals((String)"NoSuchKey", (String)e.getErrorCode());
                Assert.assertTrue((boolean)e.getMessage().startsWith("The specified key does not exist."));
            }
            String unknownPermission = "UnknownPermission";
            try {
                ObjectPermission permission = ObjectPermission.parsePermission("UnknownPermission");
                Assert.assertEquals((Object)((Object)ObjectPermission.Unknown), (Object)((Object)permission));
            }
            catch (Exception e) {
                Assert.fail((String)e.getMessage());
            }
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testUnormalGetObjectAcl() {
        String nonexistentObject = "unormal-get-object-acl";
        try {
            secondClient.getObjectAcl(bucketName, "unormal-get-object-acl");
            Assert.fail((String)"Get object acl should not be successful");
        }
        catch (OSSException e) {
            Assert.assertEquals((String)"NoSuchKey", (String)e.getErrorCode());
            Assert.assertTrue((boolean)e.getMessage().startsWith("The specified key does not exist."));
        }
        String objectUsingDefaultAcl = "object-using-default-acl";
        long inputStreamLength = 131072L;
        try {
            InputStream instream = TestUtils.genFixedLengthInputStream(131072L);
            secondClient.putObject(bucketName, "object-using-default-acl", instream);
            ObjectAcl returnedACL = secondClient.getObjectAcl(bucketName, "object-using-default-acl");
            Assert.assertEquals((Object)((Object)ObjectPermission.Default), (Object)((Object)returnedACL.getPermission()));
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testPutObjectWithACLHeader() throws IOException {
        String key = "put-object-with-acl-header";
        long inputStreamLength = 131072L;
        try {
            InputStream instream = TestUtils.genFixedLengthInputStream(131072L);
            ObjectMetadata metadata = new ObjectMetadata();
            metadata.setObjectAcl(CannedAccessControlList.PublicRead);
            secondClient.putObject(bucketName, "put-object-with-acl-header", instream, metadata);
            OSSObject o = secondClient.getObject(bucketName, "put-object-with-acl-header");
            Assert.assertEquals((String)"put-object-with-acl-header", (String)o.getKey());
            ObjectAcl returnedACL = secondClient.getObjectAcl(bucketName, "put-object-with-acl-header");
            Assert.assertEquals((Object)((Object)ObjectPermission.PublicRead), (Object)((Object)returnedACL.getPermission()));
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testAppendObjectWithACLHeader() throws IOException {
        String key = "append-object-with-acl-header";
        long inputStreamLength = 131072L;
        try {
            InputStream instream = TestUtils.genFixedLengthInputStream(131072L);
            ObjectMetadata metadata = new ObjectMetadata();
            metadata.setObjectAcl(CannedAccessControlList.PublicReadWrite);
            AppendObjectRequest appendObjectRequest = new AppendObjectRequest(bucketName, "append-object-with-acl-header", instream, metadata);
            appendObjectRequest.setPosition(0L);
            AppendObjectResult appendObjectResult = secondClient.appendObject(appendObjectRequest);
            OSSObject o = secondClient.getObject(bucketName, "append-object-with-acl-header");
            Assert.assertEquals((String)"append-object-with-acl-header", (String)o.getKey());
            Assert.assertEquals((long)131072L, (long)o.getObjectMetadata().getContentLength());
            Assert.assertEquals((String)"Appendable", (String)o.getObjectMetadata().getObjectType());
            if (appendObjectResult.getNextPosition() != null) {
                Assert.assertEquals((long)131072L, (long)appendObjectResult.getNextPosition());
            }
            String filePath = TestUtils.genFixedLengthFile(131072L);
            appendObjectRequest = new AppendObjectRequest(bucketName, "append-object-with-acl-header", new File(filePath));
            appendObjectRequest.setPosition(appendObjectResult.getNextPosition());
            appendObjectResult = secondClient.appendObject(appendObjectRequest);
            o = secondClient.getObject(bucketName, "append-object-with-acl-header");
            Assert.assertEquals((long)262144L, (long)o.getObjectMetadata().getContentLength());
            Assert.assertEquals((String)"Appendable", (String)o.getObjectMetadata().getObjectType());
            if (appendObjectResult.getNextPosition() != null) {
                Assert.assertEquals((long)262144L, (long)appendObjectResult.getNextPosition());
            }
            ObjectAcl returnedACL = secondClient.getObjectAcl(bucketName, "append-object-with-acl-header");
            Assert.assertEquals((Object)((Object)ObjectPermission.PublicReadWrite), (Object)((Object)returnedACL.getPermission()));
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testCopyObjectWithACLHeader() throws IOException {
        String sourceBucket = "copy-existing-object-source-bucket";
        String targetBucket = "copy-existing-object-target-bucket";
        String sourceKey = "copy-existing-object-source-object";
        String targetKey = "copy-existing-object-target-object";
        String userMetaKey0 = "user";
        String userMetaValue0 = "aliy";
        String userMetaKey1 = "tag";
        String userMetaValue1 = "copy-object";
        String contentType = "application/txt";
        try {
            try {
                secondClient.createBucket("copy-existing-object-source-bucket");
                secondClient.createBucket("copy-existing-object-target-bucket");
                byte[] content = new byte[]{65, 108, 105, 121, 117, 110};
                ObjectMetadata metadata = new ObjectMetadata();
                metadata.setContentLength(content.length);
                metadata.setContentType("application/octet-stream");
                metadata.addUserMetadata("user", "aliy");
                PutObjectResult putObjectResult = secondClient.putObject("copy-existing-object-source-bucket", "copy-existing-object-source-object", new ByteArrayInputStream(content), metadata);
                ObjectMetadata newObjectMetadata = new ObjectMetadata();
                newObjectMetadata.setContentLength(content.length);
                newObjectMetadata.setContentType("application/txt");
                newObjectMetadata.addUserMetadata("tag", "copy-object");
                newObjectMetadata.setObjectAcl(CannedAccessControlList.PublicRead);
                CopyObjectRequest copyObjectRequest = new CopyObjectRequest("copy-existing-object-source-bucket", "copy-existing-object-source-object", "copy-existing-object-target-bucket", "copy-existing-object-target-object");
                copyObjectRequest.setNewObjectMetadata(newObjectMetadata);
                CopyObjectResult copyObjectResult = secondClient.copyObject(copyObjectRequest);
                String sourceETag = putObjectResult.getETag();
                String targetETag = copyObjectResult.getETag();
                Assert.assertEquals((String)sourceETag, (String)targetETag);
                OSSObject ossObject = secondClient.getObject("copy-existing-object-target-bucket", "copy-existing-object-target-object");
                newObjectMetadata = ossObject.getObjectMetadata();
                Assert.assertEquals((String)"application/txt", (String)newObjectMetadata.getContentType());
                Assert.assertEquals((String)"copy-object", (String)newObjectMetadata.getUserMetadata().get("tag"));
                ObjectAcl returnedACL = secondClient.getObjectAcl("copy-existing-object-target-bucket", "copy-existing-object-target-object");
                Assert.assertEquals((Object)((Object)ObjectPermission.PublicRead), (Object)((Object)returnedACL.getPermission()));
            }
            catch (Exception e) {
                Assert.fail((String)e.getMessage());
                TestUtils.waitForCacheExpiration(5);
                ObjectAclTest.deleteBucketWithObjects(secondClient, "copy-existing-object-source-bucket");
                ObjectAclTest.deleteBucketWithObjects(secondClient, "copy-existing-object-target-bucket");
            }
        }
        finally {
            TestUtils.waitForCacheExpiration(5);
            ObjectAclTest.deleteBucketWithObjects(secondClient, "copy-existing-object-source-bucket");
            ObjectAclTest.deleteBucketWithObjects(secondClient, "copy-existing-object-target-bucket");
        }
    }

    @Test
    public void testUploadMultipartsWithAclHeader() {
        String key = "normal-upload-multiparts-with-acl-header";
        int partSize = 131072;
        int partCount = 10;
        try {
            String uploadId = TestUtils.claimUploadId(secondClient, bucketName, "normal-upload-multiparts-with-acl-header");
            ArrayList<PartETag> partETags = new ArrayList<PartETag>();
            int i = 0;
            while (i < 10) {
                InputStream instream = TestUtils.genFixedLengthInputStream(131072L);
                UploadPartRequest uploadPartRequest = new UploadPartRequest();
                uploadPartRequest.setBucketName(bucketName);
                uploadPartRequest.setKey("normal-upload-multiparts-with-acl-header");
                uploadPartRequest.setInputStream(instream);
                uploadPartRequest.setPartNumber(i + 1);
                uploadPartRequest.setPartSize(131072L);
                uploadPartRequest.setUploadId(uploadId);
                UploadPartResult uploadPartResult = secondClient.uploadPart(uploadPartRequest);
                partETags.add(uploadPartResult.getPartETag());
                ++i;
            }
            CompleteMultipartUploadRequest completeMultipartUploadRequest = new CompleteMultipartUploadRequest(bucketName, "normal-upload-multiparts-with-acl-header", uploadId, partETags);
            completeMultipartUploadRequest.setObjectACL(CannedAccessControlList.PublicRead);
            CompleteMultipartUploadResult completeMultipartUploadResult = secondClient.completeMultipartUpload(completeMultipartUploadRequest);
            Assert.assertEquals((String)TestUtils.composeLocation(secondClient, "http://oss-test.aliyun-inc.com", bucketName, "normal-upload-multiparts-with-acl-header"), (String)completeMultipartUploadResult.getLocation());
            Assert.assertEquals((String)bucketName, (String)completeMultipartUploadResult.getBucketName());
            Assert.assertEquals((String)"normal-upload-multiparts-with-acl-header", (String)completeMultipartUploadResult.getKey());
            Assert.assertEquals((String)TestUtils.calcMultipartsETag(partETags), (String)completeMultipartUploadResult.getETag());
            OSSObject o = secondClient.getObject(bucketName, "normal-upload-multiparts-with-acl-header");
            long objectSize = 0x140000L;
            Assert.assertEquals((long)0x140000L, (long)o.getObjectMetadata().getContentLength());
            Assert.assertEquals((String)TestUtils.calcMultipartsETag(partETags), (String)o.getObjectMetadata().getETag());
            ObjectAcl returnedACL = secondClient.getObjectAcl(bucketName, "normal-upload-multiparts-with-acl-header");
            Assert.assertEquals((Object)((Object)ObjectPermission.PublicRead), (Object)((Object)returnedACL.getPermission()));
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testIllegalObjectAcl() {
        String dummyKey = "test-illegal-object-acl";
        try {
            secondClient.setObjectAcl(bucketName, "test-illegal-object-acl", null);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof NullPointerException));
        }
    }

    @Test
    public void testIgnoredObjectAclHeader() {
        String dummyKey = "test-ignored-object-acl-header";
        try {
            ObjectMetadata metadata = new ObjectMetadata();
            metadata.setObjectAcl(null);
            secondClient.putObject(bucketName, "test-ignored-object-acl-header", new ByteArrayInputStream(new byte[0]), metadata);
            ObjectAcl objectAcl = secondClient.getObjectAcl(bucketName, "test-ignored-object-acl-header");
            Assert.assertEquals((Object)((Object)ObjectPermission.Default), (Object)((Object)objectAcl.getPermission()));
            metadata.setObjectAcl(CannedAccessControlList.Private);
            secondClient.putObject(bucketName, "test-ignored-object-acl-header", new ByteArrayInputStream(new byte[0]), metadata);
            objectAcl = secondClient.getObjectAcl(bucketName, "test-ignored-object-acl-header");
            Assert.assertEquals((Object)((Object)ObjectPermission.Private), (Object)((Object)objectAcl.getPermission()));
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }
}

