/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.hsf.tbremoting.invoke;

import com.taobao.hsf.domain.HSFResponse;
import com.taobao.hsf.exception.HSFException;
import com.taobao.hsf.exception.HSFTimeOutException;
import com.taobao.hsf.remoting.exception.RemotingUncheckedException;
import com.taobao.hsf.tbremoting.invoke.HSFFuture;
import com.taobao.hsf.tbremoting.invoke.HSFFutureListener;
import com.taobao.middleware.logger.support.LoggerHelper;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class HSFResponseFuture {
    public static ThreadLocal<Future<Object>> future = new ThreadLocal();
    public static ThreadLocal<HSFFutureListener> listener = new ThreadLocal();

    public static Object getResponse(long timeout) throws HSFException, InterruptedException {
        if (null == future.get()) {
            throw new HSFException("Thread [" + Thread.currentThread() + "] have not set the response future!");
        }
        try {
            HSFResponse hsfResp = (HSFResponse)future.get().get(timeout, TimeUnit.MILLISECONDS);
            if (hsfResp.isError()) {
                throw new HSFException(hsfResp.getErrorMsg(), hsfResp.getErrorMsg());
            }
            return hsfResp.getAppResponse();
        }
        catch (ExecutionException e) {
            throw new HSFTimeOutException(HSFResponseFuture.getErrorLog(), (Throwable)e);
        }
        catch (TimeoutException e) {
            throw new HSFTimeOutException(HSFResponseFuture.getErrorLog(), (Throwable)e);
        }
        catch (RemotingUncheckedException e) {
            if (e.getErrorCode().getCode() == 103) {
                throw new HSFTimeOutException(HSFResponseFuture.getErrorLog(), (Throwable)e);
            }
            throw e;
        }
    }

    private static String getErrorLog() {
        return LoggerHelper.getErrorCodeStr((String)"hsf", (String)"HSF-0002", (String)"Business problems", (String)"");
    }

    public static HSFFuture getFuture() throws HSFException {
        if (null == future.get()) {
            throw new HSFException("Thread [" + Thread.currentThread() + "] have not set the response future!");
        }
        HSFFuture hsfFuture = new HSFFuture(future.get());
        future.remove();
        return hsfFuture;
    }

    public static void setFuture(Future<Object> future) {
        HSFResponseFuture.future.set(future);
        if (listener.get() != null) {
            listener.get().onSetFuture();
        }
    }

    public static void setFutureListener(HSFFutureListener listener) {
        HSFResponseFuture.listener.set(listener);
    }
}

