/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.identity;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.activiti.engine.identity.User;
import org.activiti.rest.service.api.identity.BaseUserResource;
import org.activiti.rest.service.api.identity.UserRequest;
import org.activiti.rest.service.api.identity.UserResponse;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class UserResource
extends BaseUserResource {
    @RequestMapping(value={"/identity/users/{userId}"}, method={RequestMethod.GET}, produces={"application/json"})
    public UserResponse getUser(@PathVariable String userId, HttpServletRequest request) {
        return this.restResponseFactory.createUserResponse(this.getUserFromRequest(userId), false);
    }

    @RequestMapping(value={"/identity/users/{userId}"}, method={RequestMethod.PUT}, produces={"application/json"})
    public UserResponse updateUser(@PathVariable String userId, @RequestBody UserRequest userRequest, HttpServletRequest request) {
        User user = this.getUserFromRequest(userId);
        if (userRequest.isEmailChanged()) {
            user.setEmail(userRequest.getEmail());
        }
        if (userRequest.isFirstNameChanged()) {
            user.setFirstName(userRequest.getFirstName());
        }
        if (userRequest.isLastNameChanged()) {
            user.setLastName(userRequest.getLastName());
        }
        if (userRequest.isPasswordChanged()) {
            user.setPassword(userRequest.getPassword());
        }
        this.identityService.saveUser(user);
        return this.restResponseFactory.createUserResponse(user, false);
    }

    @RequestMapping(value={"/identity/users/{userId}"}, method={RequestMethod.DELETE})
    public void deleteUser(@PathVariable String userId, HttpServletResponse response) {
        User user = this.getUserFromRequest(userId);
        this.identityService.deleteUser(user.getId());
        response.setStatus(HttpStatus.NO_CONTENT.value());
    }
}

