/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.scoket.nettyscoket.server.handler;

import com.tydic.nicc.scoket.nettyscoket.server.service.RobotDialogueManageService;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.charset.Charset;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ChannelHandler.Sharable
public class WebSocketServerHandler
extends SimpleChannelInboundHandler<Object> {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketServerHandler.class);
    private RobotDialogueManageService dialogueManageService;
    private WebSocketServerHandshaker handshaker;

    public WebSocketServerHandler(RobotDialogueManageService dialogueManageService, WebSocketServerHandshaker handshaker) {
        this.dialogueManageService = dialogueManageService;
        this.handshaker = handshaker;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.dialogueManageService.doChannelActive(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.dialogueManageService.doChannelInactive(ctx);
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.dialogueManageService.doHandlerAdded(ctx);
    }

    public void handlerRemoved(ChannelHandlerContext ctx) {
        this.dialogueManageService.doHandlerRemoved(ctx);
    }

    protected void channelRead0(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof FullHttpRequest) {
            this.handleHttpRequest(ctx, (FullHttpRequest)msg);
        } else {
            this.dialogueManageService.doChannelRead0(ctx, msg);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.dialogueManageService.doExceptionCaught(ctx, cause);
    }

    private void handleHttpRequest(ChannelHandlerContext ctx, FullHttpRequest request) {
        try {
            if (!request.decoderResult().isSuccess() || !StringUtils.equals((CharSequence)request.headers().get("Upgrade"), (CharSequence)"websocket")) {
                this.sendHttpResponse(ctx, request, (FullHttpResponse)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.BAD_REQUEST));
                return;
            }
            WebSocketServerHandshakerFactory handshakerFactory = new WebSocketServerHandshakerFactory(WebSocketServerHandler.getWebSocketLocation(request), null, false);
            this.handshaker = handshakerFactory.newHandshaker((HttpRequest)request);
            if (this.handshaker == null) {
                WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse((Channel)ctx.channel());
            } else {
                ChannelFuture future = this.handshaker.handshake(ctx.channel(), request);
                if (future.isSuccess()) {
                    String msg = "\u5ba2\u6237\u7aef" + ctx.channel().id() + "\u52a0\u5165\u804a\u5929\u5ba4";
                    ctx.channel().writeAndFlush((Object)new TextWebSocketFrame(msg));
                }
            }
            if (null != this.dialogueManageService.doHandleHttpRequest(ctx, request) && !this.dialogueManageService.doHandleHttpRequest(ctx, request).booleanValue()) {
                String msg = "\u5ba2\u6237\u7aef\u9274\u6743\u5931\u8d25" + ctx.channel().id() + "\u9000\u51fa\uff01";
                ctx.channel().writeAndFlush((Object)new TextWebSocketFrame(msg));
                ctx.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void handleWebSocketRequest(ChannelHandlerContext ctx, WebSocketFrame req) throws Exception {
        if (req instanceof CloseWebSocketFrame) {
            this.handshaker.close(ctx.channel(), (CloseWebSocketFrame)req.retain());
            return;
        }
        if (req instanceof PingWebSocketFrame) {
            ctx.channel().write((Object)new PongWebSocketFrame(req.content().retain()));
            return;
        }
        if (!(req instanceof BinaryWebSocketFrame)) {
            throw new UnsupportedOperationException("\u5f53\u524d\u53ea\u652f\u6301\u6587\u672c\u6d88\u606f\uff0c\u4e0d\u652f\u6301\u4e8c\u8fdb\u5236\u6d88\u606f");
        }
        if (ctx == null || this.handshaker == null || ctx.isRemoved()) {
            throw new Exception("\u5c1a\u672a\u63e1\u624b\u6210\u529f\uff0c\u65e0\u6cd5\u5411\u5ba2\u6237\u7aef\u53d1\u9001WebSocket\u6d88\u606f");
        }
        ctx.channel().write((Object)new TextWebSocketFrame(((TextWebSocketFrame)req).text()));
    }

    private void sendHttpResponse(ChannelHandlerContext ctx, FullHttpRequest req, FullHttpResponse res) {
        try {
            if (res.status().code() != 200) {
                ByteBuf buf = Unpooled.copiedBuffer((CharSequence)res.status().toString(), (Charset)CharsetUtil.UTF_8);
                res.content().writeBytes(buf);
                buf.release();
                HttpUtil.setContentLength((HttpMessage)res, (long)res.content().readableBytes());
            }
            ChannelFuture cf = ctx.channel().writeAndFlush((Object)res);
            if (!HttpUtil.isKeepAlive((HttpMessage)req) || res.status().code() != 200) {
                cf.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String getWebSocketLocation(FullHttpRequest req) {
        String location = req.headers().get("Host") + "/ws";
        logger.info("location:" + location);
        return "ws://" + location;
    }
}

