/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.boot.hsf.endpoint2;

import com.ali.unit.rule.Router;
import com.alibaba.boot.hsf.HsfProperties;
import com.alibaba.boot.hsf.endpoint.ConsumerInfo;
import com.alibaba.boot.hsf.endpoint.ProviderInfo;
import com.taobao.hsf.model.ApplicationModel;
import com.taobao.hsf.model.ConsumerServiceModel;
import com.taobao.hsf.model.ProviderServiceModel;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;

@Endpoint(id="hsf")
public class HsfEndPoint {
    @Autowired
    HsfProperties hsfProperties;

    @ReadOperation
    public Map<String, Object> invoke() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("version", this.getClass().getPackage().getImplementationVersion());
        result.put("properties", this.hsfProperties);
        result.put("unit", Router.getCurrentUnit());
        Collection allProvidedServices = ApplicationModel.instance().allProvidedServices();
        LinkedList<ProviderInfo> providers = new LinkedList<ProviderInfo>();
        for (ProviderServiceModel providerServiceModel : allProvidedServices) {
            providers.add(new ProviderInfo(providerServiceModel.getMetadata()));
        }
        result.put("providers", providers);
        LinkedList<ConsumerInfo> consumers = new LinkedList<ConsumerInfo>();
        Collection allConsumedServices = ApplicationModel.instance().allConsumedServices();
        for (ConsumerServiceModel consumerServiceModel : allConsumedServices) {
            consumers.add(new ConsumerInfo(consumerServiceModel.getMetadata()));
        }
        result.put("consumers", consumers);
        return result;
    }
}

