/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.pandora.boot;

import com.taobao.pandora.boot.autoconf.AutoConfigure;
import com.taobao.pandora.boot.autoconf.Constants;
import com.taobao.pandora.boot.common.utils.AnsiLog;
import com.taobao.pandora.boot.utils.DownloadUtils;
import com.taobao.pandora.boot.utils.Md5Utils;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;

public class AutoConfigWrapper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static URL[] autoConfig(URL[] urls) {
        if (Boolean.parseBoolean(System.getProperty("autoconfig.skip", "false"))) {
            return urls;
        }
        DownloadUtils.download(Constants.DOWNLOAD_URL, Constants.AUTOCONF_JAR);
        if (!Constants.AUTOCONF_JAR.exists()) {
            AnsiLog.error((String)(Constants.AUTOCONF_JAR + " doesn't exist."));
            return urls;
        }
        String md5 = Md5Utils.md5(Constants.AUTOCONF_JAR);
        if (!"170a948e648c5b711057e693f68da5ea".equalsIgnoreCase(md5)) {
            AnsiLog.error((String)"autoconfig.jar check md5 error! expect: {}, but is: {}, please delete {}.", (Object[])new Object[]{"170a948e648c5b711057e693f68da5ea", md5, Constants.AUTOCONF_JAR.getAbsolutePath()});
        }
        AutoConfigWrapper.detectIdeaTestEnv();
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        try {
            ArrayList<URL> urlsList = new ArrayList<URL>();
            urlsList.add(Constants.AUTOCONF_JAR.toURI().toURL());
            urlsList.add(AutoConfigure.class.getProtectionDomain().getCodeSource().getLocation());
            ClassLoader parent = AutoConfigure.class.getClassLoader().getParent();
            URLClassLoader autoConfigClassLoader = new URLClassLoader(urlsList.toArray(new URL[urlsList.size()]), parent){

                @Override
                public Class<?> loadClass(String name) throws ClassNotFoundException {
                    try {
                        return super.loadClass(name);
                    }
                    catch (Exception exception) {
                        if (name.startsWith("com.taobao.pandora.boot")) {
                            try {
                                return AutoConfigure.class.getClassLoader().loadClass(name);
                            }
                            catch (Exception exception2) {
                                // empty catch block
                            }
                        }
                        return super.loadClass(name);
                    }
                }
            };
            Class<?> clazz = autoConfigClassLoader.loadClass(AutoConfigure.class.getName());
            Thread.currentThread().setContextClassLoader(autoConfigClassLoader);
            Object object = clazz.newInstance();
            Method method = clazz.getDeclaredMethod("config", URL[].class);
            URL[] uRLArray = (URL[])method.invoke(object, new Object[]{urls});
            return uRLArray;
        }
        catch (Throwable t) {
            AnsiLog.error((String)("cannot execute autoconfig successfully due to " + t));
            t.printStackTrace();
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCl);
        }
        return urls;
    }

    private static void detectIdeaTestEnv() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader instanceof URLClassLoader) {
            URL[] urls = ((URLClassLoader)classLoader).getURLs();
            boolean haveJunitJar = false;
            boolean haveTestClasses = false;
            boolean haveIdeaRtJar = false;
            for (URL url : urls) {
                String urlString = url.toString();
                if (urlString.endsWith("junit-rt.jar")) {
                    haveJunitJar = true;
                }
                if (urlString.endsWith("target/test-classes/")) {
                    haveTestClasses = true;
                }
                if (!urlString.endsWith("idea_rt.jar")) continue;
                haveIdeaRtJar = true;
            }
            if (haveJunitJar && haveTestClasses && haveIdeaRtJar) {
                AnsiLog.error((String)("[AutoConfig] Detected application is running in IDEA." + String.format("%n", new Object[0]) + "If the autoconfig input is not responding, try to run command: mvn test -DforkMode=never -DforkCount=0  " + String.format("%n", new Object[0]) + "Visit http://gitlab.alibaba-inc.com/middleware-container/pandora-boot/wikis/autoconfig for more information."));
            }
        }
    }
}

