/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.HashMap;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.handler.SimpleUrlHandlerMapping;
import org.springframework.web.servlet.i18n.CookieLocaleResolver;
import org.springframework.web.servlet.i18n.LocaleChangeInterceptor;
import org.springframework.web.servlet.mvc.Controller;
import org.springframework.web.servlet.mvc.ParameterizableViewController;
import org.springframework.web.servlet.mvc.SimpleControllerHandlerAdapter;
import org.springframework.web.servlet.mvc.UrlFilenameViewController;
import org.springframework.web.servlet.theme.ThemeChangeInterceptor;
import org.springframework.web.servlet.view.RedirectView;

@Configuration(value="casWebAppConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class CasWebAppConfiguration
implements WebMvcConfigurer {
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="localeChangeInterceptor")
    private ObjectProvider<LocaleChangeInterceptor> localeChangeInterceptor;

    @RefreshScope
    @Bean
    @Lazy
    public ThemeChangeInterceptor themeChangeInterceptor() {
        ThemeChangeInterceptor bean = new ThemeChangeInterceptor();
        bean.setParamName(this.casProperties.getTheme().getParamName());
        return bean;
    }

    @ConditionalOnMissingBean(name={"localeResolver"})
    @Bean
    @Lazy
    public LocaleResolver localeResolver() {
        return new CookieLocaleResolver(){

            protected Locale determineDefaultLocale(HttpServletRequest request) {
                Locale locale = request.getLocale();
                if (StringUtils.isBlank((CharSequence)CasWebAppConfiguration.this.casProperties.getLocale().getDefaultValue()) || !locale.getLanguage().equals(CasWebAppConfiguration.this.casProperties.getLocale().getDefaultValue())) {
                    return locale;
                }
                return new Locale(CasWebAppConfiguration.this.casProperties.getLocale().getDefaultValue());
            }
        };
    }

    @Bean
    @Lazy
    protected UrlFilenameViewController passThroughController() {
        return new UrlFilenameViewController();
    }

    @Bean
    protected Controller rootController() {
        return new ParameterizableViewController(){

            protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) {
                String queryString = request.getQueryString();
                String url = request.getContextPath() + "/login" + (String)(queryString != null ? "?" + queryString : "");
                return new ModelAndView((View)new RedirectView(response.encodeURL(url)));
            }
        };
    }

    @Bean
    @Lazy
    public SimpleUrlHandlerMapping handlerMapping() {
        SimpleUrlHandlerMapping mapping = new SimpleUrlHandlerMapping();
        Controller root = this.rootController();
        mapping.setOrder(1);
        mapping.setAlwaysUseFullPath(true);
        mapping.setRootHandler((Object)root);
        HashMap<String, Controller> urls = new HashMap<String, Controller>();
        urls.put("/", root);
        mapping.setUrlMap(urls);
        return mapping;
    }

    @Bean
    @Lazy
    public SimpleControllerHandlerAdapter simpleControllerHandlerAdapter() {
        return new SimpleControllerHandlerAdapter();
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)this.localeChangeInterceptor.getIfAvailable()).addPathPatterns(new String[]{"/**"});
    }
}

