/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.web.security.CasWebSecurityConfigurerAdapter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.security.SecurityProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration(value="casWebAppSecurityConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class CasWebAppSecurityConfiguration
implements WebMvcConfigurer {
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    private SecurityProperties securityProperties;

    @Bean
    @ConditionalOnMissingBean(name={"casWebSecurityConfigurerAdapter"})
    public WebSecurityConfigurerAdapter casWebSecurityConfigurerAdapter() {
        return new CasWebSecurityConfigurerAdapter(this.casProperties, this.securityProperties);
    }

    public void addViewControllers(ViewControllerRegistry registry) {
        registry.addViewController("/adminlogin").setViewName("casAdminLoginView");
        registry.setOrder(Integer.MIN_VALUE);
    }
}

