/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config.support.authentication;

import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlanConfigurer;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.util.AsciiArtUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="acceptUsersAuthenticationEventExecutionPlanConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class AcceptUsersAuthenticationEventExecutionPlanConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AcceptUsersAuthenticationEventExecutionPlanConfiguration.class);
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="defaultPrincipalResolver")
    private ObjectProvider<PrincipalResolver> defaultPrincipalResolver;
    @Autowired
    @Qualifier(value="acceptUsersAuthenticationHandler")
    private ObjectProvider<AuthenticationHandler> acceptUsersAuthenticationHandler;

    @ConditionalOnMissingBean(name={"acceptUsersAuthenticationEventExecutionPlanConfigurer"})
    @Bean
    @RefreshScope
    public AuthenticationEventExecutionPlanConfigurer acceptUsersAuthenticationEventExecutionPlanConfigurer() {
        return plan -> {
            if (StringUtils.isNotBlank((CharSequence)this.casProperties.getAuthn().getAccept().getUsers())) {
                String header = "\nCAS is configured to accept a static list of credentials for authentication. While this is generally useful for demo purposes, it is STRONGLY recommended that you DISABLE this authentication method (by setting 'cas.authn.accept.users' to a blank value) and switch to a mode that is more suitable for production.";
                AsciiArtUtils.printAsciiArtWarning((Logger)LOGGER, (String)"STOP!", (String)"\nCAS is configured to accept a static list of credentials for authentication. While this is generally useful for demo purposes, it is STRONGLY recommended that you DISABLE this authentication method (by setting 'cas.authn.accept.users' to a blank value) and switch to a mode that is more suitable for production.");
                plan.registerAuthenticationHandlerWithPrincipalResolver((AuthenticationHandler)this.acceptUsersAuthenticationHandler.getIfAvailable(), (PrincipalResolver)this.defaultPrincipalResolver.getIfAvailable());
            }
        };
    }
}

