/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.security;

import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.support.password.PasswordEncoderUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.authentication.PasswordEncoderProperties;
import org.apereo.cas.configuration.model.core.monitor.ActuatorEndpointProperties;
import org.apereo.cas.configuration.model.core.monitor.MonitorProperties;
import org.apereo.cas.configuration.model.support.jpa.AbstractJpaProperties;
import org.apereo.cas.configuration.model.support.ldap.LdapAuthorizationProperties;
import org.apereo.cas.configuration.support.JpaBeans;
import org.apereo.cas.web.security.authentication.MonitorEndpointLdapAuthenticationProvider;
import org.jooq.lambda.Unchecked;
import org.springframework.boot.actuate.autoconfigure.security.servlet.EndpointRequest;
import org.springframework.boot.autoconfigure.security.SecurityProperties;
import org.springframework.boot.autoconfigure.security.servlet.PathRequest;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.jaas.JaasAuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.authentication.configurers.provisioning.JdbcUserDetailsManagerConfigurer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ChannelSecurityConfigurer;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.web.util.matcher.RequestMatcher;

public class CasWebSecurityConfigurerAdapter
extends WebSecurityConfigurerAdapter {
    public static final String ENDPOINT_URL_ADMIN_FORM_LOGIN = "/adminlogin";
    private final CasConfigurationProperties casProperties;
    private final SecurityProperties securityProperties;

    protected void configure(HttpSecurity http) throws Exception {
        ((ChannelSecurityConfigurer.RequiresChannelUrl)((HttpSecurity)((HttpSecurity)((HttpSecurity)http.csrf().disable()).headers().disable()).logout().disable()).requiresChannel().requestMatchers(new RequestMatcher[]{r -> r.getHeader("X-Forwarded-Proto") != null})).requiresSecure();
        ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry requests = http.authorizeRequests();
        this.configureEndpointAccessToDenyUndefined(http, requests);
        this.configureEndpointAccessForStaticResources(requests);
        Map endpoints = this.casProperties.getMonitor().getEndpoints().getEndpoint();
        endpoints.forEach(Unchecked.biConsumer((k, v) -> {
            EndpointRequest.EndpointRequestMatcher endpoint = EndpointRequest.to((String[])new String[]{k});
            v.getAccess().forEach(Unchecked.consumer(access -> this.configureEndpointAccess(http, requests, (ActuatorEndpointProperties.EndpointAccessLevel)access, (ActuatorEndpointProperties)v, endpoint)));
        }));
    }

    protected void configure(AuthenticationManagerBuilder auth) throws Exception {
        MonitorProperties.Endpoints.JdbcSecurity jdbc;
        MonitorProperties.Endpoints.LdapSecurity ldap;
        MonitorProperties.Endpoints.JaasSecurity jaas = this.casProperties.getMonitor().getEndpoints().getJaas();
        if (jaas.getLoginConfig() != null) {
            this.configureJaasAuthenticationProvider(auth, jaas);
        }
        if (StringUtils.isNotBlank((CharSequence)(ldap = this.casProperties.getMonitor().getEndpoints().getLdap()).getLdapUrl()) && StringUtils.isNotBlank((CharSequence)ldap.getSearchFilter())) {
            this.configureLdapAuthenticationProvider(auth, ldap);
        }
        if (StringUtils.isNotBlank((CharSequence)(jdbc = this.casProperties.getMonitor().getEndpoints().getJdbc()).getQuery())) {
            this.configureJdbcAuthenticationProvider(auth, jdbc);
        }
        if (!auth.isConfigured()) {
            super.configure(auth);
        }
    }

    protected void configureJdbcAuthenticationProvider(AuthenticationManagerBuilder auth, MonitorProperties.Endpoints.JdbcSecurity jdbc) throws Exception {
        JdbcUserDetailsManagerConfigurer cfg = auth.jdbcAuthentication();
        cfg.usersByUsernameQuery(jdbc.getQuery());
        cfg.rolePrefix(jdbc.getRolePrefix());
        cfg.dataSource(JpaBeans.newDataSource((AbstractJpaProperties)jdbc));
        cfg.passwordEncoder(PasswordEncoderUtils.newPasswordEncoder((PasswordEncoderProperties)jdbc.getPasswordEncoder()));
    }

    protected void configureLdapAuthenticationProvider(AuthenticationManagerBuilder auth, MonitorProperties.Endpoints.LdapSecurity ldap) {
        if (this.isLdapAuthorizationActive()) {
            MonitorEndpointLdapAuthenticationProvider p = new MonitorEndpointLdapAuthenticationProvider(ldap, this.securityProperties);
            auth.authenticationProvider((AuthenticationProvider)p);
        }
    }

    protected void configureJaasAuthenticationProvider(AuthenticationManagerBuilder auth, MonitorProperties.Endpoints.JaasSecurity jaas) throws Exception {
        JaasAuthenticationProvider p = new JaasAuthenticationProvider();
        p.setLoginConfig(jaas.getLoginConfig());
        p.setLoginContextName(jaas.getLoginContextName());
        p.setRefreshConfigurationOnStartup(jaas.isRefreshConfigurationOnStartup());
        p.afterPropertiesSet();
        auth.authenticationProvider((AuthenticationProvider)p);
    }

    protected void configureEndpointAccessToDenyUndefined(HttpSecurity http, ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry requests) {
        Set endpoints = this.casProperties.getMonitor().getEndpoints().getEndpoint().keySet();
        String[] configuredEndpoints = endpoints.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
        ActuatorEndpointProperties endpointDefaults = this.casProperties.getMonitor().getEndpoints().getDefaultEndpointProperties();
        endpointDefaults.getAccess().forEach(Unchecked.consumer(access -> this.configureEndpointAccess(http, requests, (ActuatorEndpointProperties.EndpointAccessLevel)access, endpointDefaults, EndpointRequest.toAnyEndpoint().excluding(configuredEndpoints).excludingLinks())));
    }

    protected void configureEndpointAccessForStaticResources(ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry requests) {
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)requests.requestMatchers(new RequestMatcher[]{PathRequest.toStaticResources().atCommonLocations()})).permitAll();
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)requests.antMatchers(new String[]{"/resources/**"})).permitAll().antMatchers(new String[]{"/static/**"})).permitAll();
    }

    protected void configureEndpointAccessByFormLogin(ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry requests) throws Exception {
        ((HttpSecurity)requests.and()).formLogin().loginPage(ENDPOINT_URL_ADMIN_FORM_LOGIN).permitAll();
    }

    protected void configureEndpointAccess(HttpSecurity httpSecurity, ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry requests, ActuatorEndpointProperties.EndpointAccessLevel access, ActuatorEndpointProperties properties, EndpointRequest.EndpointRequestMatcher endpoint) throws Exception {
        switch (access) {
            case AUTHORITY: {
                this.configureEndpointAccessByAuthority(requests, properties, endpoint);
                this.configureEndpointAccessByFormLogin(requests);
                break;
            }
            case ROLE: {
                this.configureEndpointAccessByRole(requests, properties, endpoint);
                this.configureEndpointAccessByFormLogin(requests);
                break;
            }
            case AUTHENTICATED: {
                this.configureEndpointAccessAuthenticated(requests, endpoint);
                this.configureEndpointAccessByFormLogin(requests);
                break;
            }
            case IP_ADDRESS: {
                this.configureEndpointAccessByIpAddress(requests, properties, endpoint);
                break;
            }
            case PERMIT: {
                this.configureEndpointAccessPermitAll(requests, endpoint);
                break;
            }
            case ANONYMOUS: {
                this.configureEndpointAccessAnonymously(requests, endpoint);
                break;
            }
            default: {
                this.configureEndpointAccessToDenyAll(requests, endpoint);
            }
        }
    }

    private void configureEndpointAccessPermitAll(ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry requests, EndpointRequest.EndpointRequestMatcher endpoint) {
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)requests.requestMatchers(new RequestMatcher[]{endpoint})).permitAll();
    }

    private void configureEndpointAccessToDenyAll(ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry requests, EndpointRequest.EndpointRequestMatcher endpoint) {
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)requests.requestMatchers(new RequestMatcher[]{endpoint})).denyAll();
    }

    private void configureEndpointAccessAnonymously(ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry requests, EndpointRequest.EndpointRequestMatcher endpoint) {
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)requests.requestMatchers(new RequestMatcher[]{endpoint})).anonymous();
    }

    private void configureEndpointAccessByIpAddress(ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry requests, ActuatorEndpointProperties properties, EndpointRequest.EndpointRequestMatcher endpoint) {
        String addresses = properties.getRequiredIpAddresses().stream().map(address -> "hasIpAddress('" + address + "')").collect(Collectors.joining(" or "));
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)requests.requestMatchers(new RequestMatcher[]{endpoint})).access(addresses);
    }

    private void configureEndpointAccessAuthenticated(ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry requests, EndpointRequest.EndpointRequestMatcher endpoint) throws Exception {
        ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)requests.requestMatchers(new RequestMatcher[]{endpoint})).authenticated().and()).httpBasic();
    }

    private void configureEndpointAccessByRole(ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry requests, ActuatorEndpointProperties properties, EndpointRequest.EndpointRequestMatcher endpoint) throws Exception {
        ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)requests.requestMatchers(new RequestMatcher[]{endpoint})).hasAnyRole(properties.getRequiredRoles().toArray(ArrayUtils.EMPTY_STRING_ARRAY)).and()).httpBasic();
    }

    private void configureEndpointAccessByAuthority(ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry requests, ActuatorEndpointProperties properties, EndpointRequest.EndpointRequestMatcher endpoint) throws Exception {
        ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)requests.requestMatchers(new RequestMatcher[]{endpoint})).hasAnyAuthority(properties.getRequiredAuthorities().toArray(ArrayUtils.EMPTY_STRING_ARRAY)).and()).httpBasic();
    }

    private boolean isLdapAuthorizationActive() {
        MonitorProperties.Endpoints.LdapSecurity ldap = this.casProperties.getMonitor().getEndpoints().getLdap();
        LdapAuthorizationProperties authZ = ldap.getLdapAuthz();
        return StringUtils.isNotBlank((CharSequence)ldap.getBaseDn()) && StringUtils.isNotBlank((CharSequence)ldap.getLdapUrl()) && StringUtils.isNotBlank((CharSequence)ldap.getSearchFilter()) && (StringUtils.isNotBlank((CharSequence)authZ.getRoleAttribute()) || StringUtils.isNotBlank((CharSequence)authZ.getGroupAttribute()));
    }

    @Generated
    public CasWebSecurityConfigurerAdapter(CasConfigurationProperties casProperties, SecurityProperties securityProperties) {
        this.casProperties = casProperties;
        this.securityProperties = securityProperties;
    }
}

