/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.security.authentication;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authorization.LdapUserAttributesToRolesAuthorizationGenerator;
import org.apereo.cas.authorization.LdapUserGroupsToRolesAuthorizationGenerator;
import org.apereo.cas.configuration.model.core.monitor.MonitorProperties;
import org.apereo.cas.configuration.model.support.ldap.AbstractLdapAuthenticationProperties;
import org.apereo.cas.configuration.model.support.ldap.AbstractLdapProperties;
import org.apereo.cas.configuration.model.support.ldap.LdapAuthorizationProperties;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.LdapUtils;
import org.apereo.cas.util.Pac4jUtils;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.Credential;
import org.ldaptive.LdapEntry;
import org.ldaptive.ReturnAttributes;
import org.ldaptive.SearchExecutor;
import org.ldaptive.auth.AuthenticationRequest;
import org.ldaptive.auth.AuthenticationResponse;
import org.ldaptive.auth.Authenticator;
import org.ldaptive.pool.PooledConnectionFactory;
import org.pac4j.core.authorization.authorizer.RequireAnyRoleAuthorizer;
import org.pac4j.core.authorization.generator.AuthorizationGenerator;
import org.pac4j.core.context.J2EContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.profile.CommonProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.security.SecurityProperties;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public class MonitorEndpointLdapAuthenticationProvider
implements AuthenticationProvider {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(MonitorEndpointLdapAuthenticationProvider.class);
    private final MonitorProperties.Endpoints.LdapSecurity ldapProperties;
    private final SecurityProperties securityProperties;

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        try {
            String password;
            String username = authentication.getPrincipal().toString();
            Object credentials = authentication.getCredentials();
            String string = password = credentials == null ? null : credentials.toString();
            if (StringUtils.isBlank((CharSequence)password)) {
                throw new IllegalArgumentException("Password cannot be blank");
            }
            LOGGER.debug("Preparing LDAP authentication request for user [{}]", (Object)username);
            AuthenticationRequest request = new AuthenticationRequest(username, new Credential(password), ReturnAttributes.ALL.value());
            Authenticator authenticator = LdapUtils.newLdaptiveAuthenticator((AbstractLdapAuthenticationProperties)this.ldapProperties);
            LOGGER.debug("Executing LDAP authentication request for user [{}]", (Object)username);
            AuthenticationResponse response = authenticator.authenticate(request);
            LOGGER.debug("LDAP response: [{}]", (Object)response);
            if (((Boolean)response.getResult()).booleanValue()) {
                LdapEntry entry = response.getLdapEntry();
                CommonProfile profile = new CommonProfile();
                profile.setId(username);
                entry.getAttributes().forEach(a -> profile.addAttribute(a.getName(), (Object)a.getStringValues()));
                LOGGER.debug("Collected user profile [{}]", (Object)profile);
                J2EContext context = Pac4jUtils.getPac4jJ2EContext();
                AuthorizationGenerator<CommonProfile> authZGen = this.buildAuthorizationGenerator();
                authZGen.generate((WebContext)context, profile);
                LOGGER.debug("Assembled user profile with roles after generating authorization claims [{}]", (Object)profile);
                ArrayList authorities = profile.getRoles().stream().map(SimpleGrantedAuthority::new).collect(Collectors.toCollection(ArrayList::new));
                LOGGER.debug("List of authorities remapped from profile roles are [{}]", (Object)authorities);
                RequireAnyRoleAuthorizer authorizer = new RequireAnyRoleAuthorizer(this.securityProperties.getUser().getRoles());
                LOGGER.debug("Executing authorization for expected admin roles [{}]", (Object)authorizer.getElements());
                if (authorizer.isAllAuthorized((WebContext)context, CollectionUtils.wrap((Object)profile))) {
                    return new UsernamePasswordAuthenticationToken((Object)username, (Object)password, (Collection)authorities);
                }
                LOGGER.warn("User [{}] is not authorized to access the requested resource allowed to roles [{}]", (Object)username, (Object)authorizer.getElements());
            } else {
                LOGGER.warn("LDAP authentication response produced no results for [{}]", (Object)username);
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new InsufficientAuthenticationException("Unexpected LDAP error", (Throwable)e);
        }
        throw new BadCredentialsException("Could not authenticate provided credentials");
    }

    public boolean supports(Class<?> aClass) {
        return UsernamePasswordAuthenticationToken.class.isAssignableFrom(aClass);
    }

    private AuthorizationGenerator<CommonProfile> buildAuthorizationGenerator() {
        LdapAuthorizationProperties ldapAuthz = this.ldapProperties.getLdapAuthz();
        PooledConnectionFactory connectionFactory = LdapUtils.newLdaptivePooledConnectionFactory((AbstractLdapProperties)this.ldapProperties);
        if (this.isGroupBasedAuthorization()) {
            LOGGER.debug("Handling LDAP authorization based on groups");
            return new LdapUserGroupsToRolesAuthorizationGenerator((ConnectionFactory)connectionFactory, this.ldapAuthorizationGeneratorUserSearchExecutor(), ldapAuthz.isAllowMultipleResults(), ldapAuthz.getGroupAttribute(), ldapAuthz.getGroupPrefix(), this.ldapAuthorizationGeneratorGroupSearchExecutor());
        }
        LOGGER.debug("Handling LDAP authorization based on attributes and roles");
        return new LdapUserAttributesToRolesAuthorizationGenerator((ConnectionFactory)connectionFactory, this.ldapAuthorizationGeneratorUserSearchExecutor(), ldapAuthz.isAllowMultipleResults(), ldapAuthz.getRoleAttribute(), ldapAuthz.getRolePrefix());
    }

    private boolean isGroupBasedAuthorization() {
        LdapAuthorizationProperties ldapAuthz = this.ldapProperties.getLdapAuthz();
        return StringUtils.isNotBlank((CharSequence)ldapAuthz.getGroupFilter()) && StringUtils.isNotBlank((CharSequence)ldapAuthz.getGroupAttribute());
    }

    private SearchExecutor ldapAuthorizationGeneratorUserSearchExecutor() {
        LdapAuthorizationProperties ldapAuthz = this.ldapProperties.getLdapAuthz();
        return LdapUtils.newLdaptiveSearchExecutor((String)ldapAuthz.getBaseDn(), (String)ldapAuthz.getSearchFilter(), new ArrayList(0), (List)CollectionUtils.wrap((Object)ldapAuthz.getRoleAttribute()));
    }

    private SearchExecutor ldapAuthorizationGeneratorGroupSearchExecutor() {
        LdapAuthorizationProperties ldapAuthz = this.ldapProperties.getLdapAuthz();
        return LdapUtils.newLdaptiveSearchExecutor((String)ldapAuthz.getGroupBaseDn(), (String)ldapAuthz.getGroupFilter(), new ArrayList(0), (List)CollectionUtils.wrap((Object)ldapAuthz.getGroupAttribute()));
    }

    @Generated
    public MonitorEndpointLdapAuthenticationProvider(MonitorProperties.Endpoints.LdapSecurity ldapProperties, SecurityProperties securityProperties) {
        this.ldapProperties = ldapProperties;
        this.securityProperties = securityProperties;
    }
}

