/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.cas.authentication;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cache.Cache;
import org.springframework.security.cas.authentication.CasAuthenticationToken;
import org.springframework.security.cas.authentication.StatelessTicketCache;
import org.springframework.util.Assert;

public class SpringCacheBasedTicketCache
implements StatelessTicketCache {
    private static final Log logger = LogFactory.getLog(SpringCacheBasedTicketCache.class);
    private final Cache cache;

    public SpringCacheBasedTicketCache(Cache cache) throws Exception {
        Assert.notNull((Object)cache, (String)"cache mandatory");
        this.cache = cache;
    }

    @Override
    public CasAuthenticationToken getByTicketId(String serviceTicket) {
        Cache.ValueWrapper element;
        Cache.ValueWrapper valueWrapper = element = serviceTicket != null ? this.cache.get((Object)serviceTicket) : null;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Cache hit: " + (element != null) + "; service ticket: " + serviceTicket));
        }
        return element == null ? null : (CasAuthenticationToken)element.get();
    }

    @Override
    public void putTicketInCache(CasAuthenticationToken token) {
        String key = token.getCredentials().toString();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Cache put: " + key));
        }
        this.cache.put((Object)key, (Object)token);
    }

    @Override
    public void removeTicketFromCache(CasAuthenticationToken token) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Cache remove: " + token.getCredentials().toString()));
        }
        this.removeTicketFromCache(token.getCredentials().toString());
    }

    @Override
    public void removeTicketFromCache(String serviceTicket) {
        this.cache.evict((Object)serviceTicket);
    }
}

