/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.tensorflow.engine;

import ai.djl.Device;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.types.DataType;
import ai.djl.tensorflow.engine.TfDataType;
import ai.djl.tensorflow.engine.TfNDArray;
import ai.djl.tensorflow.engine.TfNDManager;
import ai.djl.tensorflow.engine.javacpp.JavacppUtils;
import ai.djl.util.Preconditions;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.PointerPointer;
import org.bytedeco.javacpp.PointerScope;
import org.tensorflow.internal.c_api.TFE_Context;
import org.tensorflow.internal.c_api.TFE_Op;
import org.tensorflow.internal.c_api.TFE_TensorHandle;
import org.tensorflow.internal.c_api.TF_Status;
import org.tensorflow.internal.c_api.global.tensorflow;

final class TfOpExecutor
implements AutoCloseable {
    private TfNDManager manager;
    private TFE_Op opHandle;
    private AtomicBoolean closed;

    TfOpExecutor(TfNDManager manager, TFE_Context eagerSessionHandle, String operation) {
        this.manager = manager;
        this.closed = new AtomicBoolean(false);
        try (PointerScope ignore = new PointerScope();){
            TF_Status status = TF_Status.newStatus();
            this.opHandle = TFE_Op.newOp((TFE_Context)eagerSessionHandle, (String)operation, (TF_Status)status);
            status.throwExceptionIfNotOK();
            this.opHandle.retainReference();
        }
        this.setDevice(manager.getDevice());
    }

    public NDArray[] build(int numOutputs) {
        TFE_TensorHandle[] handles = this.buildRawPointer(numOutputs);
        NDArray[] outputs = new NDArray[handles.length];
        for (int i = 0; i < handles.length; ++i) {
            outputs[i] = new TfNDArray(this.manager, handles[i]);
        }
        return outputs;
    }

    public NDArray buildSingletonOrThrow() {
        TFE_TensorHandle[] handles = this.buildRawPointer(1);
        try {
            Preconditions.checkArgument((handles.length == 1 ? 1 : 0) != 0, (String)("The expected size of outputs is 1 but got " + handles.length));
        }
        catch (IllegalArgumentException e) {
            Arrays.stream(handles).forEach(Pointer::close);
            throw e;
        }
        return new TfNDArray(this.manager, handles[0]);
    }

    public TFE_TensorHandle[] buildRawPointer(int numOutputs) {
        try {
            TFE_TensorHandle[] tFE_TensorHandleArray;
            try (PointerScope ignore = new PointerScope();){
                IntPointer numReturnValues = new IntPointer(1L).put(numOutputs);
                PointerPointer returnValues = new PointerPointer((long)numOutputs);
                TF_Status status = TF_Status.newStatus();
                tensorflow.TFE_Execute((TFE_Op)this.opHandle, (PointerPointer)returnValues, (IntPointer)numReturnValues, (TF_Status)status);
                status.throwExceptionIfNotOK();
                TFE_TensorHandle[] results = new TFE_TensorHandle[numReturnValues.get()];
                for (int i = 0; i < results.length; ++i) {
                    results[i] = (TFE_TensorHandle)((TFE_TensorHandle)returnValues.get(TFE_TensorHandle.class, (long)i)).withDeallocator().retainReference();
                }
                tFE_TensorHandleArray = results;
            }
            return tFE_TensorHandleArray;
        }
        finally {
            this.close();
        }
    }

    public TfOpExecutor addInput(NDArray input) {
        try (PointerScope ignore = new PointerScope();){
            TF_Status status = TF_Status.newStatus();
            tensorflow.TFE_OpAddInput((TFE_Op)this.opHandle, (TFE_TensorHandle)((TFE_TensorHandle)((TfNDArray)input).getHandle()), (TF_Status)status);
            status.throwExceptionIfNotOK();
        }
        return this;
    }

    public TfOpExecutor addInputList(NDArray[] inputs) {
        TFE_TensorHandle[] inputHandles = (TFE_TensorHandle[])Arrays.stream(inputs).map(array -> (TFE_TensorHandle)((TfNDArray)((Object)array)).getHandle()).toArray(TFE_TensorHandle[]::new);
        try (PointerScope ignore = new PointerScope();){
            PointerPointer tensorPointers = new PointerPointer((long)inputHandles.length);
            for (int i = 0; i < inputHandles.length; ++i) {
                tensorPointers.put((long)i, (Pointer)inputHandles[i]);
            }
            TF_Status status = TF_Status.newStatus();
            tensorflow.TFE_OpAddInputList((TFE_Op)this.opHandle, (PointerPointer)tensorPointers, (int)inputHandles.length, (TF_Status)status);
            status.throwExceptionIfNotOK();
        }
        return this;
    }

    public TfOpExecutor setDevice(Device device) {
        TfOpExecutor tfOpExecutor;
        PointerScope ignore = new PointerScope();
        try {
            String deviceStr = JavacppUtils.toTfDevice(device);
            TF_Status status = TF_Status.newStatus();
            tensorflow.TFE_OpSetDevice((TFE_Op)this.opHandle, (String)deviceStr, (TF_Status)status);
            status.throwExceptionIfNotOK();
            tfOpExecutor = this;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ignore.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                this.close();
                throw e;
            }
        }
        ignore.close();
        return tfOpExecutor;
    }

    public TfOpExecutor addParam(String name, String value) {
        byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
        try (PointerScope ignore = new PointerScope();){
            tensorflow.TFE_OpSetAttrString((TFE_Op)this.opHandle, (String)name, (Pointer)new BytePointer(bytes), (long)bytes.length);
        }
        return this;
    }

    public TfOpExecutor addParam(String name, long value) {
        tensorflow.TFE_OpSetAttrInt((TFE_Op)this.opHandle, (String)name, (long)value);
        return this;
    }

    public TfOpExecutor addParam(String name, float value) {
        tensorflow.TFE_OpSetAttrFloat((TFE_Op)this.opHandle, (String)name, (float)value);
        return this;
    }

    public TfOpExecutor addParam(String name, boolean value) {
        tensorflow.TFE_OpSetAttrBool((TFE_Op)this.opHandle, (String)name, (byte)((byte)(value ? 1 : 0)));
        return this;
    }

    public TfOpExecutor addParam(String name, DataType dataType) {
        tensorflow.TFE_OpSetAttrType((TFE_Op)this.opHandle, (String)name, (int)TfDataType.toTf(dataType));
        return this;
    }

    public TfOpExecutor addParam(String name, long[] values) {
        tensorflow.TFE_OpSetAttrIntList((TFE_Op)this.opHandle, (String)name, (long[])values, (int)values.length);
        return this;
    }

    @Override
    public void close() {
        if (this.closed.getAndSet(true) || this.opHandle == null || this.opHandle.isNull()) {
            return;
        }
        this.opHandle.close();
    }
}

