/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc;

import org.postgresql.log.Log;
import org.postgresql.log.Logger;
import org.postgresql.util.GT;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

class BooleanTypeUtil {
    private static Log LOGGER = Logger.getLogger(BooleanTypeUtil.class.getName());

    private BooleanTypeUtil() {
    }

    static boolean castToBoolean(Object in) throws PSQLException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Cast to boolean: \"" + String.valueOf(in) + "\"");
        }
        if (in instanceof Boolean) {
            return (Boolean)in;
        }
        if (in instanceof String) {
            return BooleanTypeUtil.fromString((String)in);
        }
        if (in instanceof Character) {
            return BooleanTypeUtil.fromCharacter((Character)in);
        }
        if (in instanceof Number) {
            return BooleanTypeUtil.fromNumber((Number)in);
        }
        throw new PSQLException("Cannot cast to boolean", PSQLState.CANNOT_COERCE);
    }

    private static boolean fromString(String strval) throws PSQLException {
        String val = strval.trim();
        if (val.contains("1") && val.contains("0")) {
            throw BooleanTypeUtil.cannotCoerceException(strval);
        }
        if (val.contains("1") || "true".equalsIgnoreCase(val) || "t".equalsIgnoreCase(val) || "yes".equalsIgnoreCase(val) || "y".equalsIgnoreCase(val) || "on".equalsIgnoreCase(val)) {
            return true;
        }
        if (val.contains("0") || "false".equalsIgnoreCase(val) || "f".equalsIgnoreCase(val) || "no".equalsIgnoreCase(val) || "n".equalsIgnoreCase(val) || "off".equalsIgnoreCase(val)) {
            return false;
        }
        throw BooleanTypeUtil.cannotCoerceException(strval);
    }

    private static boolean fromCharacter(Character charval) throws PSQLException {
        if ('1' == charval.charValue() || 't' == charval.charValue() || 'T' == charval.charValue() || 'y' == charval.charValue() || 'Y' == charval.charValue()) {
            return true;
        }
        if ('0' == charval.charValue() || 'f' == charval.charValue() || 'F' == charval.charValue() || 'n' == charval.charValue() || 'N' == charval.charValue()) {
            return false;
        }
        throw BooleanTypeUtil.cannotCoerceException(charval);
    }

    private static boolean fromNumber(Number numval) throws PSQLException {
        double value = numval.doubleValue();
        if (value == 1.0) {
            return true;
        }
        if (value == 0.0) {
            return false;
        }
        throw BooleanTypeUtil.cannotCoerceException(numval);
    }

    private static PSQLException cannotCoerceException(Object value) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Cannot cast to boolean: \"" + String.valueOf(value) + "\"");
        }
        return new PSQLException(GT.tr("Cannot cast to boolean: \"{0}\"", String.valueOf(value)), PSQLState.CANNOT_COERCE);
    }
}

