/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.math;

import cn.hutool.core.util.ArrayUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class Arrangement
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String[] datas;

    public Arrangement(String[] datas) {
        this.datas = datas;
    }

    public static long count(int n) {
        return Arrangement.count(n, n);
    }

    public static long count(int n, int m) {
        if (m < 0 || m > n) {
            throw new IllegalArgumentException("n >= 0 && m >= 0 && m <= n required");
        }
        if (m == 0) {
            return 1L;
        }
        long result = 1L;
        for (int i = 0; i < m; ++i) {
            long next = result * (long)(n - i);
            if (next < result) {
                throw new ArithmeticException("Overflow computing A(" + n + "," + m + ")");
            }
            result = next;
        }
        return result;
    }

    public static long countAll(int n) {
        long total = 0L;
        for (int i = 1; i <= n; ++i) {
            total += Arrangement.count(n, i);
        }
        return total;
    }

    public List<String[]> select() {
        return this.select(this.datas.length);
    }

    public List<String[]> select(int m) {
        if (m < 0 || m > this.datas.length) {
            return Collections.emptyList();
        }
        if (m == 0) {
            return Collections.singletonList(new String[0]);
        }
        long estimated = Arrangement.count(this.datas.length, m);
        int capacity = estimated > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)estimated;
        ArrayList<String[]> result = new ArrayList<String[]>(capacity);
        boolean[] visited = new boolean[this.datas.length];
        this.dfs(new String[m], 0, visited, result);
        return result;
    }

    public List<String[]> selectAll() {
        ArrayList<String[]> result = new ArrayList<String[]>();
        for (int m = 1; m <= this.datas.length; ++m) {
            result.addAll(this.select(m));
        }
        return result;
    }

    private void select(String[] datas, String[] resultList, int resultIndex, List<String[]> result) {
        if (resultIndex >= resultList.length) {
            if (!result.contains(resultList)) {
                result.add(Arrays.copyOf(resultList, resultList.length));
            }
            return;
        }
        for (int i = 0; i < datas.length; ++i) {
            resultList[resultIndex] = datas[i];
            this.select(ArrayUtil.remove(datas, i), resultList, resultIndex + 1, result);
        }
    }

    public Iterable<String[]> iterate(int m) {
        return () -> new ArrangementIterator(this.datas, m);
    }

    private void dfs(String[] current, int depth, boolean[] visited, List<String[]> result) {
        if (depth == current.length) {
            result.add(Arrays.copyOf(current, current.length));
            return;
        }
        for (int i = 0; i < this.datas.length; ++i) {
            if (visited[i]) continue;
            visited[i] = true;
            current[depth] = this.datas[i];
            this.dfs(current, depth + 1, visited, result);
            visited[i] = false;
        }
    }

    private static class ArrangementIterator
    implements Iterator<String[]> {
        private final String[] datas;
        private final int n;
        private final int m;
        private final boolean[] visited;
        private final String[] buffer;
        private final int[] indices;
        private int depth;
        private boolean end;
        private String[] nextItem;
        private boolean nextPrepared;

        ArrangementIterator(String[] datas, int m) {
            this.datas = datas;
            this.n = datas.length;
            this.m = m;
            this.visited = new boolean[this.n];
            this.nextItem = null;
            this.nextPrepared = false;
            if (m < 0 || m > this.n) {
                this.indices = new int[Math.max(1, m)];
                this.buffer = new String[Math.max(1, m)];
                this.depth = -1;
                this.end = true;
            } else if (m == 0) {
                this.indices = new int[0];
                this.buffer = new String[0];
                this.depth = 0;
                this.end = false;
            } else {
                this.indices = new int[m];
                Arrays.fill(this.indices, -1);
                this.buffer = new String[m];
                this.depth = 0;
                this.end = false;
            }
        }

        @Override
        public boolean hasNext() {
            if (this.end) {
                return false;
            }
            if (this.nextPrepared) {
                return this.nextItem != null;
            }
            this.prepareNext();
            return this.nextItem != null;
        }

        @Override
        public String[] next() {
            if (this.end && !this.nextPrepared) {
                throw new NoSuchElementException();
            }
            if (!this.nextPrepared) {
                this.prepareNext();
            }
            if (this.nextItem == null) {
                throw new NoSuchElementException();
            }
            String[] ret = this.nextItem;
            this.nextItem = null;
            this.nextPrepared = false;
            if (this.m == 0) {
                this.end = true;
            }
            return ret;
        }

        private void prepareNext() {
            if (this.nextPrepared || this.end) {
                this.nextPrepared = true;
                return;
            }
            if (this.m == 0) {
                this.nextItem = new String[0];
                this.nextPrepared = true;
                return;
            }
            while (this.depth >= 0) {
                int start = this.indices[this.depth] + 1;
                boolean found = false;
                for (int i = start; i < this.n; ++i) {
                    if (this.visited[i]) continue;
                    if (this.indices[this.depth] != -1) {
                        this.visited[this.indices[this.depth]] = false;
                    }
                    this.indices[this.depth] = i;
                    this.visited[i] = true;
                    this.buffer[this.depth] = this.datas[i];
                    found = true;
                    break;
                }
                if (!found) {
                    if (this.indices[this.depth] != -1) {
                        this.visited[this.indices[this.depth]] = false;
                        this.indices[this.depth] = -1;
                    }
                    --this.depth;
                    continue;
                }
                if (this.depth == this.m - 1) {
                    this.nextItem = Arrays.copyOf(this.buffer, this.m);
                    this.visited[this.indices[this.depth]] = false;
                    this.nextPrepared = true;
                    return;
                }
                ++this.depth;
                if (this.depth >= this.m) continue;
                this.indices[this.depth] = -1;
            }
            this.end = true;
            this.nextItem = null;
            this.nextPrepared = true;
        }
    }
}

