/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.cron.pattern.matcher;

import cn.hutool.core.date.Month;
import cn.hutool.cron.pattern.matcher.BoolArrayMatcher;
import java.util.List;

public class DayOfMonthMatcher
extends BoolArrayMatcher {
    private static final int LAST_DAY = 32;

    public DayOfMonthMatcher(List<Integer> intValueList) {
        super(intValueList);
    }

    public boolean match(int dayValue, int month, boolean isLeapYear) {
        return super.match(dayValue) || this.matchLastDay(dayValue, month, isLeapYear);
    }

    public int nextAfter(int dayValue, int month, boolean isLeapYear) {
        int maxValue = this.getMaxValue(month, isLeapYear);
        int minValue = this.getMinValue(month, isLeapYear);
        if (dayValue > minValue) {
            boolean[] bValues = this.bValues;
            while (dayValue <= maxValue) {
                if (bValues[dayValue] || dayValue == maxValue && this.match(32)) {
                    return dayValue;
                }
                ++dayValue;
            }
        }
        return minValue;
    }

    public boolean isLast() {
        return this.match(32);
    }

    public boolean isLastDay(Integer value, Integer month, boolean isLeapYear) {
        return this.matchLastDay(value, month, isLeapYear);
    }

    public int getMinValue(int month, boolean isLeapYear) {
        int minValue = super.getMinValue();
        if (32 == minValue) {
            return DayOfMonthMatcher.getLastDay(month, isLeapYear);
        }
        return minValue;
    }

    public int getMaxValue(int month, boolean isLeapYear) {
        return Math.min(super.getMaxValue(), DayOfMonthMatcher.getLastDay(month, isLeapYear));
    }

    private boolean matchLastDay(int dayValue, int month, boolean isLeapYear) {
        return dayValue > 27 && this.match(32) && dayValue == DayOfMonthMatcher.getLastDay(month, isLeapYear);
    }

    private static int getLastDay(int month, boolean isLeapYear) {
        return Month.getLastDay(month - 1, isLeapYear);
    }
}

