/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.extra.ssh;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.ftp.AbstractFtp;
import cn.hutool.extra.ftp.FtpConfig;
import cn.hutool.extra.ftp.FtpException;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.connection.channel.direct.Session;
import net.schmizz.sshj.sftp.RemoteResourceInfo;
import net.schmizz.sshj.sftp.SFTPClient;
import net.schmizz.sshj.transport.verification.HostKeyVerifier;
import net.schmizz.sshj.transport.verification.PromiscuousVerifier;
import net.schmizz.sshj.xfer.FileSystemFile;
import net.schmizz.sshj.xfer.LocalDestFile;
import net.schmizz.sshj.xfer.LocalSourceFile;

public class SshjSftp
extends AbstractFtp {
    private SSHClient ssh;
    private SFTPClient sftp;
    private Session session;
    private String workingDir;

    public SshjSftp(String sshHost) {
        this(new FtpConfig(sshHost, 22, null, null, DEFAULT_CHARSET));
    }

    public SshjSftp(String sshHost, String sshUser, String sshPass) {
        this(new FtpConfig(sshHost, 22, sshUser, sshPass, CharsetUtil.CHARSET_UTF_8));
    }

    public SshjSftp(String sshHost, int sshPort, String sshUser, String sshPass) {
        this(new FtpConfig(sshHost, sshPort, sshUser, sshPass, CharsetUtil.CHARSET_UTF_8));
    }

    public SshjSftp(String sshHost, int sshPort, String sshUser, String sshPass, Charset charset) {
        this(new FtpConfig(sshHost, sshPort, sshUser, sshPass, charset));
    }

    public SshjSftp(FtpConfig config) {
        super(config);
        this.init();
    }

    public void init() {
        this.ssh = new SSHClient();
        this.ssh.addHostKeyVerifier((HostKeyVerifier)new PromiscuousVerifier());
        try {
            this.ssh.connect(this.ftpConfig.getHost(), this.ftpConfig.getPort());
            this.ssh.authPassword(this.ftpConfig.getUser(), this.ftpConfig.getPassword());
            this.ssh.setRemoteCharset(this.ftpConfig.getCharset());
            this.sftp = this.ssh.newSFTPClient();
        }
        catch (IOException e) {
            throw new FtpException("sftp \u521d\u59cb\u5316\u5931\u8d25.", e);
        }
    }

    @Override
    public AbstractFtp reconnectIfTimeout() {
        if (StrUtil.isBlank(this.ftpConfig.getHost())) {
            throw new FtpException("Host is blank!");
        }
        try {
            this.cd("/");
        }
        catch (FtpException e) {
            this.close();
            this.init();
        }
        return this;
    }

    @Override
    public boolean cd(String directory) {
        String newPath = this.getPath(directory);
        try {
            this.sftp.ls(newPath);
            this.workingDir = newPath;
            return true;
        }
        catch (IOException e) {
            throw new FtpException(e);
        }
    }

    @Override
    public String pwd() {
        return this.getPath(null);
    }

    @Override
    public boolean mkdir(String dir) {
        try {
            this.sftp.mkdir(this.getPath(dir));
        }
        catch (IOException e) {
            throw new FtpException(e);
        }
        return this.containsFile(this.getPath(dir));
    }

    @Override
    public List<String> ls(String path) {
        List infoList;
        try {
            infoList = this.sftp.ls(this.getPath(path));
        }
        catch (IOException e) {
            throw new FtpException(e);
        }
        if (CollUtil.isNotEmpty(infoList)) {
            return CollUtil.map(infoList, RemoteResourceInfo::getName, true);
        }
        return null;
    }

    @Override
    public boolean delFile(String path) {
        try {
            this.sftp.rm(this.getPath(path));
            return !this.containsFile(this.getPath(path));
        }
        catch (IOException e) {
            throw new FtpException(e);
        }
    }

    @Override
    public boolean delDir(String dirPath) {
        try {
            this.sftp.rmdir(this.getPath(dirPath));
            return !this.containsFile(this.getPath(dirPath));
        }
        catch (IOException e) {
            throw new FtpException(e);
        }
    }

    @Override
    public boolean upload(String destPath, File file) {
        try {
            if (StrUtil.endWith((CharSequence)destPath, "/")) {
                destPath = destPath + file.getName();
            }
            this.sftp.put((LocalSourceFile)new FileSystemFile(file), this.getPath(destPath));
            return this.containsFile(this.getPath(destPath));
        }
        catch (IOException e) {
            throw new FtpException(e);
        }
    }

    @Override
    public void download(String path, File outFile) {
        try {
            this.sftp.get(this.getPath(path), (LocalDestFile)new FileSystemFile(outFile));
        }
        catch (IOException e) {
            throw new FtpException(e);
        }
    }

    @Override
    public void recursiveDownloadFolder(String sourcePath, File destDir) {
        if (!(destDir.exists() && destDir.isDirectory() || destDir.mkdirs())) {
            throw new FtpException("\u521b\u5efa\u76ee\u5f55" + destDir.getAbsolutePath() + "\u5931\u8d25");
        }
        List<String> files = this.ls(this.getPath(sourcePath));
        if (files != null && !files.isEmpty()) {
            files.forEach(file -> this.download(sourcePath + "/" + file, FileUtil.file(destDir, file)));
        }
    }

    @Override
    public void rename(String from, String to) {
        try {
            this.sftp.rename(from, to);
        }
        catch (IOException e) {
            throw new FtpException(e);
        }
    }

    @Override
    public void close() {
        IoUtil.close((Closeable)this.session);
        IoUtil.close((Closeable)this.sftp);
        IoUtil.close((Closeable)this.ssh);
    }

    public boolean containsFile(String fileDir) {
        try {
            this.sftp.lstat(this.getPath(fileDir));
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public String command(String exec) {
        Session session = this.initSession();
        Session.Command command = null;
        try {
            command = session.exec(exec);
            InputStream inputStream = command.getInputStream();
            String string = IoUtil.read(inputStream, this.ftpConfig.getCharset());
            return string;
        }
        catch (Exception e) {
            throw new FtpException(e);
        }
        finally {
            IoUtil.close((Closeable)command);
        }
    }

    private Session initSession() {
        Session session = this.session;
        if (null == session || !session.isOpen()) {
            IoUtil.close((Closeable)session);
            try {
                session = this.ssh.startSession();
            }
            catch (Exception e) {
                throw new FtpException(e);
            }
            this.session = session;
        }
        return session;
    }

    private String getPath(String path) {
        if (StrUtil.isBlank(this.workingDir)) {
            try {
                this.workingDir = this.sftp.canonicalize("");
            }
            catch (IOException e) {
                throw new FtpException(e);
            }
        }
        if (StrUtil.isBlank(path)) {
            return this.workingDir;
        }
        if (StrUtil.startWith((CharSequence)path, "/")) {
            return path;
        }
        String tmp = StrUtil.removeSuffix(this.workingDir, "/");
        return StrUtil.format("{}/{}", tmp, path);
    }
}

