/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.convert;

import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;

public class NumberWordFormatter {
    private static final String[] NUMBER = new String[]{"", "ONE", "TWO", "THREE", "FOUR", "FIVE", "SIX", "SEVEN", "EIGHT", "NINE"};
    private static final String[] NUMBER_TEEN = new String[]{"TEN", "ELEVEN", "TWELVE", "THIRTEEN", "FOURTEEN", "FIFTEEN", "SIXTEEN", "SEVENTEEN", "EIGHTEEN", "NINETEEN"};
    private static final String[] NUMBER_TEN = new String[]{"TEN", "TWENTY", "THIRTY", "FORTY", "FIFTY", "SIXTY", "SEVENTY", "EIGHTY", "NINETY"};
    private static final String[] NUMBER_MORE = new String[]{"", "THOUSAND", "MILLION", "BILLION", "TRILLION"};
    private static final String[] NUMBER_SUFFIX = new String[]{"k", "w", "m", "b", "t", "p", "e"};
    private static final int[] STANDARD_UNIT_INDICES = new int[]{0, 2, 3, 4, 5, 6};

    public static String format(Object x) {
        if (x != null) {
            return NumberWordFormatter.format(x.toString());
        }
        return "";
    }

    public static String formatSimple(long value) {
        return NumberWordFormatter.formatSimple(value, true);
    }

    public static String formatSimple(long value, boolean isTwo) {
        int index;
        if (value < 1000L) {
            return String.valueOf(value);
        }
        double res = value;
        if (isTwo) {
            if (value >= 10000L) {
                res = (double)value / 10000.0;
                index = 1;
            } else {
                res = (double)value / 1000.0;
                index = 0;
            }
        } else {
            int unitIndex;
            for (unitIndex = -1; res >= 1000.0 && unitIndex < STANDARD_UNIT_INDICES.length - 1; res /= 1000.0, ++unitIndex) {
            }
            index = STANDARD_UNIT_INDICES[unitIndex];
        }
        return String.format("%s%s", NumberUtil.decimalFormat("#.##", res), NUMBER_SUFFIX[index]);
    }

    private static String format(String x) {
        String xs;
        String lstr;
        int z = x.indexOf(".");
        String rstr = "";
        if (z > -1) {
            lstr = x.substring(0, z);
            rstr = x.substring(z + 1);
        } else {
            lstr = x;
        }
        String lstrrev = StrUtil.reverse(lstr);
        String[] a = new String[5];
        switch (lstrrev.length() % 3) {
            case 1: {
                lstrrev = lstrrev + "00";
                break;
            }
            case 2: {
                lstrrev = lstrrev + "0";
            }
        }
        StringBuilder lm = new StringBuilder();
        for (int i = 0; i < lstrrev.length() / 3; ++i) {
            a[i] = StrUtil.reverse(lstrrev.substring(3 * i, 3 * i + 3));
            if (!"000".equals(a[i])) {
                if (i != 0) {
                    lm.insert(0, NumberWordFormatter.transThree(a[i]) + " " + NumberWordFormatter.parseMore(i) + " ");
                    continue;
                }
                lm = new StringBuilder(NumberWordFormatter.transThree(a[i]));
                continue;
            }
            lm.append(NumberWordFormatter.transThree(a[i]));
        }
        String string = xs = lm.length() == 0 ? "ZERO " : " ";
        if (z > -1) {
            xs = xs + "AND CENTS " + NumberWordFormatter.transTwo(rstr) + " ";
        }
        return lm.toString().trim() + xs + "ONLY";
    }

    private static String parseTeen(String s) {
        return NUMBER_TEEN[Integer.parseInt(s) - 10];
    }

    private static String parseTen(String s) {
        return NUMBER_TEN[Integer.parseInt(s.substring(0, 1)) - 1];
    }

    private static String parseMore(int i) {
        return NUMBER_MORE[i];
    }

    private static String transTwo(String s) {
        if (s.length() > 2) {
            s = s.substring(0, 2);
        } else if (s.length() < 2) {
            s = s + "0";
        }
        String value = s.startsWith("0") ? NumberWordFormatter.parseLast(s) : (s.startsWith("1") ? NumberWordFormatter.parseTeen(s) : (s.endsWith("0") ? NumberWordFormatter.parseTen(s) : NumberWordFormatter.parseTen(s) + " " + NumberWordFormatter.parseLast(s)));
        return value;
    }

    private static String transThree(String s) {
        String value = s.startsWith("0") ? NumberWordFormatter.transTwo(s.substring(1)) : ("00".equals(s.substring(1)) ? NumberWordFormatter.parseLast(s.substring(0, 1)) + " HUNDRED" : NumberWordFormatter.parseLast(s.substring(0, 1)) + " HUNDRED AND " + NumberWordFormatter.transTwo(s.substring(1)));
        return value;
    }

    private static String parseLast(String s) {
        return NUMBER[Integer.parseInt(s.substring(s.length() - 1))];
    }
}

