/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.aggregations.AggregationVariant;
import co.elastic.clients.elasticsearch._types.aggregations.BucketPathAggregation;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class BucketKsAggregation
extends BucketPathAggregation
implements AggregationVariant {
    private final List<String> alternative;
    private final List<Double> fractions;
    @Nullable
    private final String samplingMethod;
    public static final JsonpDeserializer<BucketKsAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, BucketKsAggregation::setupBucketKsAggregationDeserializer);

    private BucketKsAggregation(Builder builder) {
        super(builder);
        this.alternative = ApiTypeHelper.unmodifiable(builder.alternative);
        this.fractions = ApiTypeHelper.unmodifiable(builder.fractions);
        this.samplingMethod = builder.samplingMethod;
    }

    public static BucketKsAggregation of(Function<Builder, ObjectBuilder<BucketKsAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregation.Kind _aggregationKind() {
        return Aggregation.Kind.BucketCountKsTest;
    }

    public final List<String> alternative() {
        return this.alternative;
    }

    public final List<Double> fractions() {
        return this.fractions;
    }

    @Nullable
    public final String samplingMethod() {
        return this.samplingMethod;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (ApiTypeHelper.isDefined(this.alternative)) {
            generator.writeKey("alternative");
            generator.writeStartArray();
            for (String string : this.alternative) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.fractions)) {
            generator.writeKey("fractions");
            generator.writeStartArray();
            for (Double d : this.fractions) {
                generator.write(d.doubleValue());
            }
            generator.writeEnd();
        }
        if (this.samplingMethod != null) {
            generator.writeKey("sampling_method");
            generator.write(this.samplingMethod);
        }
    }

    protected static void setupBucketKsAggregationDeserializer(ObjectDeserializer<Builder> op) {
        BucketPathAggregation.setupBucketPathAggregationDeserializer(op);
        op.add(Builder::alternative, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "alternative");
        op.add(Builder::fractions, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.doubleDeserializer()), "fractions");
        op.add(Builder::samplingMethod, JsonpDeserializer.stringDeserializer(), "sampling_method");
    }

    public static class Builder
    extends BucketPathAggregation.AbstractBuilder<Builder>
    implements ObjectBuilder<BucketKsAggregation> {
        @Nullable
        private List<String> alternative;
        @Nullable
        private List<Double> fractions;
        @Nullable
        private String samplingMethod;

        public final Builder alternative(List<String> list) {
            this.alternative = Builder._listAddAll(this.alternative, list);
            return this;
        }

        public final Builder alternative(String value, String ... values) {
            this.alternative = Builder._listAdd(this.alternative, value, values);
            return this;
        }

        public final Builder fractions(List<Double> list) {
            this.fractions = Builder._listAddAll(this.fractions, list);
            return this;
        }

        public final Builder fractions(Double value, Double ... values) {
            this.fractions = Builder._listAdd(this.fractions, value, values);
            return this;
        }

        public final Builder samplingMethod(@Nullable String value) {
            this.samplingMethod = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public BucketKsAggregation build() {
            this._checkSingleUse();
            return new BucketKsAggregation(this);
        }
    }
}

