/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.SignificantTermsBucketBase;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class SignificantLongTermsBucket
extends SignificantTermsBucketBase {
    private final long key;
    @Nullable
    private final String keyAsString;
    public static final JsonpDeserializer<SignificantLongTermsBucket> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SignificantLongTermsBucket::setupSignificantLongTermsBucketDeserializer);

    private SignificantLongTermsBucket(Builder builder) {
        super(builder);
        this.key = ApiTypeHelper.requireNonNull(builder.key, this, "key");
        this.keyAsString = builder.keyAsString;
    }

    public static SignificantLongTermsBucket of(Function<Builder, ObjectBuilder<SignificantLongTermsBucket>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long key() {
        return this.key;
    }

    @Nullable
    public final String keyAsString() {
        return this.keyAsString;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("key");
        generator.write(this.key);
        if (this.keyAsString != null) {
            generator.writeKey("key_as_string");
            generator.write(this.keyAsString);
        }
    }

    protected static void setupSignificantLongTermsBucketDeserializer(ObjectDeserializer<Builder> op) {
        SignificantTermsBucketBase.setupSignificantTermsBucketBaseDeserializer(op);
        op.add(Builder::key, JsonpDeserializer.longDeserializer(), "key");
        op.add(Builder::keyAsString, JsonpDeserializer.stringDeserializer(), "key_as_string");
    }

    public static class Builder
    extends SignificantTermsBucketBase.AbstractBuilder<Builder>
    implements ObjectBuilder<SignificantLongTermsBucket> {
        private Long key;
        @Nullable
        private String keyAsString;

        public final Builder key(long value) {
            this.key = value;
            return this;
        }

        public final Builder keyAsString(@Nullable String value) {
            this.keyAsString = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SignificantLongTermsBucket build() {
            this._checkSingleUse();
            return new SignificantLongTermsBucket(this);
        }
    }
}

