/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.FieldValue;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.aggregations.AggregationVariant;
import co.elastic.clients.elasticsearch._types.aggregations.BucketAggregationBase;
import co.elastic.clients.elasticsearch._types.aggregations.DateRangeExpression;
import co.elastic.clients.elasticsearch.security.query_api_keys.ApiKeyAggregation;
import co.elastic.clients.elasticsearch.security.query_api_keys.ApiKeyAggregationVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class DateRangeAggregation
extends BucketAggregationBase
implements AggregationVariant,
ApiKeyAggregationVariant,
JsonpSerializable {
    @Nullable
    private final String field;
    @Nullable
    private final String format;
    @Nullable
    private final FieldValue missing;
    private final List<DateRangeExpression> ranges;
    @Nullable
    private final String timeZone;
    @Nullable
    private final Boolean keyed;
    public static final JsonpDeserializer<DateRangeAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DateRangeAggregation::setupDateRangeAggregationDeserializer);

    private DateRangeAggregation(Builder builder) {
        this.field = builder.field;
        this.format = builder.format;
        this.missing = builder.missing;
        this.ranges = ApiTypeHelper.unmodifiable(builder.ranges);
        this.timeZone = builder.timeZone;
        this.keyed = builder.keyed;
    }

    public static DateRangeAggregation of(Function<Builder, ObjectBuilder<DateRangeAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregation.Kind _aggregationKind() {
        return Aggregation.Kind.DateRange;
    }

    @Override
    public ApiKeyAggregation.Kind _apiKeyAggregationKind() {
        return ApiKeyAggregation.Kind.DateRange;
    }

    @Nullable
    public final String field() {
        return this.field;
    }

    @Nullable
    public final String format() {
        return this.format;
    }

    @Nullable
    public final FieldValue missing() {
        return this.missing;
    }

    public final List<DateRangeExpression> ranges() {
        return this.ranges;
    }

    @Nullable
    public final String timeZone() {
        return this.timeZone;
    }

    @Nullable
    public final Boolean keyed() {
        return this.keyed;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.field != null) {
            generator.writeKey("field");
            generator.write(this.field);
        }
        if (this.format != null) {
            generator.writeKey("format");
            generator.write(this.format);
        }
        if (this.missing != null) {
            generator.writeKey("missing");
            this.missing.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.ranges)) {
            generator.writeKey("ranges");
            generator.writeStartArray();
            for (DateRangeExpression item0 : this.ranges) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.timeZone != null) {
            generator.writeKey("time_zone");
            generator.write(this.timeZone);
        }
        if (this.keyed != null) {
            generator.writeKey("keyed");
            generator.write(this.keyed.booleanValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupDateRangeAggregationDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::format, JsonpDeserializer.stringDeserializer(), "format");
        op.add(Builder::missing, FieldValue._DESERIALIZER, "missing");
        op.add(Builder::ranges, JsonpDeserializer.arrayDeserializer(DateRangeExpression._DESERIALIZER), "ranges");
        op.add(Builder::timeZone, JsonpDeserializer.stringDeserializer(), "time_zone");
        op.add(Builder::keyed, JsonpDeserializer.booleanDeserializer(), "keyed");
    }

    public static class Builder
    extends BucketAggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<DateRangeAggregation> {
        @Nullable
        private String field;
        @Nullable
        private String format;
        @Nullable
        private FieldValue missing;
        @Nullable
        private List<DateRangeExpression> ranges;
        @Nullable
        private String timeZone;
        @Nullable
        private Boolean keyed;

        public final Builder field(@Nullable String value) {
            this.field = value;
            return this;
        }

        public final Builder format(@Nullable String value) {
            this.format = value;
            return this;
        }

        public final Builder missing(@Nullable FieldValue value) {
            this.missing = value;
            return this;
        }

        public final Builder missing(Function<FieldValue.Builder, ObjectBuilder<FieldValue>> fn) {
            return this.missing(fn.apply(new FieldValue.Builder()).build());
        }

        public final Builder missing(String value) {
            this.missing = FieldValue.of(value);
            return this;
        }

        public final Builder missing(long value) {
            this.missing = FieldValue.of(value);
            return this;
        }

        public final Builder missing(double value) {
            this.missing = FieldValue.of(value);
            return this;
        }

        public final Builder missing(boolean value) {
            this.missing = FieldValue.of(value);
            return this;
        }

        public final Builder ranges(List<DateRangeExpression> list) {
            this.ranges = Builder._listAddAll(this.ranges, list);
            return this;
        }

        public final Builder ranges(DateRangeExpression value, DateRangeExpression ... values) {
            this.ranges = Builder._listAdd(this.ranges, value, values);
            return this;
        }

        public final Builder ranges(Function<DateRangeExpression.Builder, ObjectBuilder<DateRangeExpression>> fn) {
            return this.ranges(fn.apply(new DateRangeExpression.Builder()).build(), new DateRangeExpression[0]);
        }

        public final Builder timeZone(@Nullable String value) {
            this.timeZone = value;
            return this;
        }

        public final Builder keyed(@Nullable Boolean value) {
            this.keyed = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DateRangeAggregation build() {
            this._checkSingleUse();
            return new DateRangeAggregation(this);
        }
    }
}

