/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch.security.ApplicationPrivileges;
import co.elastic.clients.elasticsearch.security.ClusterPrivilege;
import co.elastic.clients.elasticsearch.security.GlobalPrivilege;
import co.elastic.clients.elasticsearch.security.IndicesPrivileges;
import co.elastic.clients.elasticsearch.security.RemoteClusterPrivileges;
import co.elastic.clients.elasticsearch.security.RemoteIndicesPrivileges;
import co.elastic.clients.elasticsearch.security.Restriction;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class RoleDescriptorRead
implements JsonpSerializable {
    private final List<String> cluster;
    private final List<IndicesPrivileges> indices;
    private final List<RemoteIndicesPrivileges> remoteIndices;
    private final List<RemoteClusterPrivileges> remoteCluster;
    private final List<GlobalPrivilege> global;
    private final List<ApplicationPrivileges> applications;
    private final Map<String, JsonData> metadata;
    private final List<String> runAs;
    @Nullable
    private final String description;
    @Nullable
    private final Restriction restriction;
    private final Map<String, JsonData> transientMetadata;
    public static final JsonpDeserializer<RoleDescriptorRead> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RoleDescriptorRead::setupRoleDescriptorReadDeserializer);

    private RoleDescriptorRead(Builder builder) {
        this.cluster = ApiTypeHelper.unmodifiableRequired(builder.cluster, (Object)this, "cluster");
        this.indices = ApiTypeHelper.unmodifiableRequired(builder.indices, (Object)this, "indices");
        this.remoteIndices = ApiTypeHelper.unmodifiable(builder.remoteIndices);
        this.remoteCluster = ApiTypeHelper.unmodifiable(builder.remoteCluster);
        this.global = ApiTypeHelper.unmodifiable(builder.global);
        this.applications = ApiTypeHelper.unmodifiable(builder.applications);
        this.metadata = ApiTypeHelper.unmodifiable(builder.metadata);
        this.runAs = ApiTypeHelper.unmodifiable(builder.runAs);
        this.description = builder.description;
        this.restriction = builder.restriction;
        this.transientMetadata = ApiTypeHelper.unmodifiable(builder.transientMetadata);
    }

    public static RoleDescriptorRead of(Function<Builder, ObjectBuilder<RoleDescriptorRead>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<String> cluster() {
        return this.cluster;
    }

    public final List<IndicesPrivileges> indices() {
        return this.indices;
    }

    public final List<RemoteIndicesPrivileges> remoteIndices() {
        return this.remoteIndices;
    }

    public final List<RemoteClusterPrivileges> remoteCluster() {
        return this.remoteCluster;
    }

    public final List<GlobalPrivilege> global() {
        return this.global;
    }

    public final List<ApplicationPrivileges> applications() {
        return this.applications;
    }

    public final Map<String, JsonData> metadata() {
        return this.metadata;
    }

    public final List<String> runAs() {
        return this.runAs;
    }

    @Nullable
    public final String description() {
        return this.description;
    }

    @Nullable
    public final Restriction restriction() {
        return this.restriction;
    }

    public final Map<String, JsonData> transientMetadata() {
        return this.transientMetadata;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.cluster)) {
            generator.writeKey("cluster");
            generator.writeStartArray();
            for (String string : this.cluster) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.indices)) {
            generator.writeKey("indices");
            generator.writeStartArray();
            for (IndicesPrivileges indicesPrivileges : this.indices) {
                indicesPrivileges.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.remoteIndices)) {
            generator.writeKey("remote_indices");
            generator.writeStartArray();
            for (RemoteIndicesPrivileges remoteIndicesPrivileges : this.remoteIndices) {
                remoteIndicesPrivileges.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.remoteCluster)) {
            generator.writeKey("remote_cluster");
            generator.writeStartArray();
            for (RemoteClusterPrivileges remoteClusterPrivileges : this.remoteCluster) {
                remoteClusterPrivileges.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.global)) {
            generator.writeKey("global");
            generator.writeStartArray();
            for (GlobalPrivilege globalPrivilege : this.global) {
                globalPrivilege.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.applications)) {
            generator.writeKey("applications");
            generator.writeStartArray();
            for (ApplicationPrivileges applicationPrivileges : this.applications) {
                applicationPrivileges.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.metadata)) {
            generator.writeKey("metadata");
            generator.writeStartObject();
            for (Map.Entry entry : this.metadata.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((JsonData)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.runAs)) {
            generator.writeKey("run_as");
            generator.writeStartArray();
            for (String string : this.runAs) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.description != null) {
            generator.writeKey("description");
            generator.write(this.description);
        }
        if (this.restriction != null) {
            generator.writeKey("restriction");
            this.restriction.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.transientMetadata)) {
            generator.writeKey("transient_metadata");
            generator.writeStartObject();
            for (Map.Entry entry : this.transientMetadata.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((JsonData)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupRoleDescriptorReadDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::cluster, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "cluster");
        op.add(Builder::indices, JsonpDeserializer.arrayDeserializer(IndicesPrivileges._DESERIALIZER), "indices", "index");
        op.add(Builder::remoteIndices, JsonpDeserializer.arrayDeserializer(RemoteIndicesPrivileges._DESERIALIZER), "remote_indices");
        op.add(Builder::remoteCluster, JsonpDeserializer.arrayDeserializer(RemoteClusterPrivileges._DESERIALIZER), "remote_cluster");
        op.add(Builder::global, JsonpDeserializer.arrayDeserializer(GlobalPrivilege._DESERIALIZER), "global");
        op.add(Builder::applications, JsonpDeserializer.arrayDeserializer(ApplicationPrivileges._DESERIALIZER), "applications");
        op.add(Builder::metadata, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "metadata");
        op.add(Builder::runAs, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "run_as");
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description");
        op.add(Builder::restriction, Restriction._DESERIALIZER, "restriction");
        op.add(Builder::transientMetadata, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "transient_metadata");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<RoleDescriptorRead> {
        private List<String> cluster;
        private List<IndicesPrivileges> indices;
        @Nullable
        private List<RemoteIndicesPrivileges> remoteIndices;
        @Nullable
        private List<RemoteClusterPrivileges> remoteCluster;
        @Nullable
        private List<GlobalPrivilege> global;
        @Nullable
        private List<ApplicationPrivileges> applications;
        @Nullable
        private Map<String, JsonData> metadata;
        @Nullable
        private List<String> runAs;
        @Nullable
        private String description;
        @Nullable
        private Restriction restriction;
        @Nullable
        private Map<String, JsonData> transientMetadata;

        public final Builder cluster(List<String> list) {
            this.cluster = Builder._listAddAll(this.cluster, list);
            return this;
        }

        public final Builder cluster(String value, String ... values) {
            this.cluster = Builder._listAdd(this.cluster, value, values);
            return this;
        }

        public final Builder cluster(ClusterPrivilege value, ClusterPrivilege ... values) {
            this.cluster = Builder._listAdd(this.cluster, value.jsonValue(), (String[])Arrays.stream(values).map(ClusterPrivilege::jsonValue).toArray(String[]::new));
            return this;
        }

        public final Builder indices(List<IndicesPrivileges> list) {
            this.indices = Builder._listAddAll(this.indices, list);
            return this;
        }

        public final Builder indices(IndicesPrivileges value, IndicesPrivileges ... values) {
            this.indices = Builder._listAdd(this.indices, value, values);
            return this;
        }

        public final Builder indices(Function<IndicesPrivileges.Builder, ObjectBuilder<IndicesPrivileges>> fn) {
            return this.indices(fn.apply(new IndicesPrivileges.Builder()).build(), new IndicesPrivileges[0]);
        }

        public final Builder remoteIndices(List<RemoteIndicesPrivileges> list) {
            this.remoteIndices = Builder._listAddAll(this.remoteIndices, list);
            return this;
        }

        public final Builder remoteIndices(RemoteIndicesPrivileges value, RemoteIndicesPrivileges ... values) {
            this.remoteIndices = Builder._listAdd(this.remoteIndices, value, values);
            return this;
        }

        public final Builder remoteIndices(Function<RemoteIndicesPrivileges.Builder, ObjectBuilder<RemoteIndicesPrivileges>> fn) {
            return this.remoteIndices(fn.apply(new RemoteIndicesPrivileges.Builder()).build(), new RemoteIndicesPrivileges[0]);
        }

        public final Builder remoteCluster(List<RemoteClusterPrivileges> list) {
            this.remoteCluster = Builder._listAddAll(this.remoteCluster, list);
            return this;
        }

        public final Builder remoteCluster(RemoteClusterPrivileges value, RemoteClusterPrivileges ... values) {
            this.remoteCluster = Builder._listAdd(this.remoteCluster, value, values);
            return this;
        }

        public final Builder remoteCluster(Function<RemoteClusterPrivileges.Builder, ObjectBuilder<RemoteClusterPrivileges>> fn) {
            return this.remoteCluster(fn.apply(new RemoteClusterPrivileges.Builder()).build(), new RemoteClusterPrivileges[0]);
        }

        public final Builder global(List<GlobalPrivilege> list) {
            this.global = Builder._listAddAll(this.global, list);
            return this;
        }

        public final Builder global(GlobalPrivilege value, GlobalPrivilege ... values) {
            this.global = Builder._listAdd(this.global, value, values);
            return this;
        }

        public final Builder global(Function<GlobalPrivilege.Builder, ObjectBuilder<GlobalPrivilege>> fn) {
            return this.global(fn.apply(new GlobalPrivilege.Builder()).build(), new GlobalPrivilege[0]);
        }

        public final Builder applications(List<ApplicationPrivileges> list) {
            this.applications = Builder._listAddAll(this.applications, list);
            return this;
        }

        public final Builder applications(ApplicationPrivileges value, ApplicationPrivileges ... values) {
            this.applications = Builder._listAdd(this.applications, value, values);
            return this;
        }

        public final Builder applications(Function<ApplicationPrivileges.Builder, ObjectBuilder<ApplicationPrivileges>> fn) {
            return this.applications(fn.apply(new ApplicationPrivileges.Builder()).build(), new ApplicationPrivileges[0]);
        }

        public final Builder metadata(Map<String, JsonData> map) {
            this.metadata = Builder._mapPutAll(this.metadata, map);
            return this;
        }

        public final Builder metadata(String key, JsonData value) {
            this.metadata = Builder._mapPut(this.metadata, key, value);
            return this;
        }

        public final Builder runAs(List<String> list) {
            this.runAs = Builder._listAddAll(this.runAs, list);
            return this;
        }

        public final Builder runAs(String value, String ... values) {
            this.runAs = Builder._listAdd(this.runAs, value, values);
            return this;
        }

        public final Builder description(@Nullable String value) {
            this.description = value;
            return this;
        }

        public final Builder restriction(@Nullable Restriction value) {
            this.restriction = value;
            return this;
        }

        public final Builder restriction(Function<Restriction.Builder, ObjectBuilder<Restriction>> fn) {
            return this.restriction(fn.apply(new Restriction.Builder()).build());
        }

        public final Builder transientMetadata(Map<String, JsonData> map) {
            this.transientMetadata = Builder._mapPutAll(this.transientMetadata, map);
            return this;
        }

        public final Builder transientMetadata(String key, JsonData value) {
            this.transientMetadata = Builder._mapPut(this.transientMetadata, key, value);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RoleDescriptorRead build() {
            this._checkSingleUse();
            return new RoleDescriptorRead(this);
        }
    }
}

