/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import javax.annotation.Nullable;

public abstract class TokenFilterBase
implements JsonpSerializable {
    @Nullable
    private final String version;

    protected TokenFilterBase(AbstractBuilder<?> builder) {
        this.version = ((AbstractBuilder)builder).version;
    }

    @Nullable
    public final String version() {
        return this.version;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.version != null) {
            generator.writeKey("version");
            generator.write(this.version);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupTokenFilterBaseDeserializer(ObjectDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::version, JsonpDeserializer.stringDeserializer(), "version");
    }

    public static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends WithJsonObjectBuilderBase<BuilderT> {
        @Nullable
        private String version;

        public final BuilderT version(@Nullable String value) {
            this.version = value;
            return (BuilderT)this.self();
        }

        @Override
        protected abstract BuilderT self();
    }
}

