/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryBase;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PrefixQuery
extends QueryBase
implements QueryVariant {
    private final String field;
    @Nullable
    private final String rewrite;
    private final String value;
    @Nullable
    private final Boolean caseInsensitive;
    public static final JsonpDeserializer<PrefixQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PrefixQuery::setupPrefixQueryDeserializer);

    private PrefixQuery(Builder builder) {
        super(builder);
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.rewrite = builder.rewrite;
        this.value = ApiTypeHelper.requireNonNull(builder.value, this, "value");
        this.caseInsensitive = builder.caseInsensitive;
    }

    public static PrefixQuery of(Function<Builder, ObjectBuilder<PrefixQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Query.Kind _queryKind() {
        return Query.Kind.Prefix;
    }

    public final String field() {
        return this.field;
    }

    @Nullable
    public final String rewrite() {
        return this.rewrite;
    }

    public final String value() {
        return this.value;
    }

    @Nullable
    public final Boolean caseInsensitive() {
        return this.caseInsensitive;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject(this.field);
        super.serializeInternal(generator, mapper);
        if (this.rewrite != null) {
            generator.writeKey("rewrite");
            generator.write(this.rewrite);
        }
        generator.writeKey("value");
        generator.write(this.value);
        if (this.caseInsensitive != null) {
            generator.writeKey("case_insensitive");
            generator.write(this.caseInsensitive.booleanValue());
        }
        generator.writeEnd();
    }

    protected static void setupPrefixQueryDeserializer(ObjectDeserializer<Builder> op) {
        QueryBase.setupQueryBaseDeserializer(op);
        op.add(Builder::rewrite, JsonpDeserializer.stringDeserializer(), "rewrite");
        op.add(Builder::value, JsonpDeserializer.stringDeserializer(), "value");
        op.add(Builder::caseInsensitive, JsonpDeserializer.booleanDeserializer(), "case_insensitive");
        op.setKey(Builder::field, JsonpDeserializer.stringDeserializer());
        op.shortcutProperty("value");
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PrefixQuery> {
        private String field;
        @Nullable
        private String rewrite;
        private String value;
        @Nullable
        private Boolean caseInsensitive;

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder rewrite(@Nullable String value) {
            this.rewrite = value;
            return this;
        }

        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final Builder caseInsensitive(@Nullable Boolean value) {
            this.caseInsensitive = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PrefixQuery build() {
            this._checkSingleUse();
            return new PrefixQuery(this);
        }
    }
}

