/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.DataframeAnalyticsStatsHyperparameters;
import co.elastic.clients.elasticsearch.ml.DataframeAnalyticsStatsOutlierDetection;
import co.elastic.clients.elasticsearch.ml.DataframeAnalyticsStatsVariant;
import co.elastic.clients.json.JsonEnum;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class DataframeAnalyticsStats
implements TaggedUnion<Kind, Object>,
JsonpSerializable {
    private final Kind _kind;
    private final Object _value;
    public static final JsonpDeserializer<DataframeAnalyticsStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DataframeAnalyticsStats::setupDataframeAnalyticsStatsDeserializer, Builder::build);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    public DataframeAnalyticsStats(DataframeAnalyticsStatsVariant value) {
        this._kind = ApiTypeHelper.requireNonNull(value._dataframeAnalyticsStatsKind(), this, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(value, this, "<variant value>");
    }

    private DataframeAnalyticsStats(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static DataframeAnalyticsStats of(Function<Builder, ObjectBuilder<DataframeAnalyticsStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isClassificationStats() {
        return this._kind == Kind.ClassificationStats;
    }

    public DataframeAnalyticsStatsHyperparameters classificationStats() {
        return (DataframeAnalyticsStatsHyperparameters)TaggedUnionUtils.get(this, Kind.ClassificationStats);
    }

    public boolean isOutlierDetectionStats() {
        return this._kind == Kind.OutlierDetectionStats;
    }

    public DataframeAnalyticsStatsOutlierDetection outlierDetectionStats() {
        return (DataframeAnalyticsStatsOutlierDetection)TaggedUnionUtils.get(this, Kind.OutlierDetectionStats);
    }

    public boolean isRegressionStats() {
        return this._kind == Kind.RegressionStats;
    }

    public DataframeAnalyticsStatsHyperparameters regressionStats() {
        return (DataframeAnalyticsStatsHyperparameters)TaggedUnionUtils.get(this, Kind.RegressionStats);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        generator.writeKey(this._kind.jsonValue());
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupDataframeAnalyticsStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::classificationStats, DataframeAnalyticsStatsHyperparameters._DESERIALIZER, "classification_stats");
        op.add(Builder::outlierDetectionStats, DataframeAnalyticsStatsOutlierDetection._DESERIALIZER, "outlier_detection_stats");
        op.add(Builder::regressionStats, DataframeAnalyticsStatsHyperparameters._DESERIALIZER, "regression_stats");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<DataframeAnalyticsStats> {
        private Kind _kind;
        private Object _value;

        @Override
        protected Builder self() {
            return this;
        }

        public ObjectBuilder<DataframeAnalyticsStats> classificationStats(DataframeAnalyticsStatsHyperparameters v) {
            this._kind = Kind.ClassificationStats;
            this._value = v;
            return this;
        }

        public ObjectBuilder<DataframeAnalyticsStats> classificationStats(Function<DataframeAnalyticsStatsHyperparameters.Builder, ObjectBuilder<DataframeAnalyticsStatsHyperparameters>> fn) {
            return this.classificationStats(fn.apply(new DataframeAnalyticsStatsHyperparameters.Builder()).build());
        }

        public ObjectBuilder<DataframeAnalyticsStats> outlierDetectionStats(DataframeAnalyticsStatsOutlierDetection v) {
            this._kind = Kind.OutlierDetectionStats;
            this._value = v;
            return this;
        }

        public ObjectBuilder<DataframeAnalyticsStats> outlierDetectionStats(Function<DataframeAnalyticsStatsOutlierDetection.Builder, ObjectBuilder<DataframeAnalyticsStatsOutlierDetection>> fn) {
            return this.outlierDetectionStats(fn.apply(new DataframeAnalyticsStatsOutlierDetection.Builder()).build());
        }

        public ObjectBuilder<DataframeAnalyticsStats> regressionStats(DataframeAnalyticsStatsHyperparameters v) {
            this._kind = Kind.RegressionStats;
            this._value = v;
            return this;
        }

        public ObjectBuilder<DataframeAnalyticsStats> regressionStats(Function<DataframeAnalyticsStatsHyperparameters.Builder, ObjectBuilder<DataframeAnalyticsStatsHyperparameters>> fn) {
            return this.regressionStats(fn.apply(new DataframeAnalyticsStatsHyperparameters.Builder()).build());
        }

        @Override
        public DataframeAnalyticsStats build() {
            this._checkSingleUse();
            return new DataframeAnalyticsStats(this);
        }
    }

    public static enum Kind implements JsonEnum
    {
        ClassificationStats("classification_stats"),
        OutlierDetectionStats("outlier_detection_stats"),
        RegressionStats("regression_stats");

        private final String jsonValue;

        private Kind(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        @Override
        public String jsonValue() {
            return this.jsonValue;
        }
    }
}

