/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml.put_trained_model;

import co.elastic.clients.elasticsearch.ml.put_trained_model.Preprocessor;
import co.elastic.clients.elasticsearch.ml.put_trained_model.TrainedModel;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class Definition
implements JsonpSerializable {
    private final List<Preprocessor> preprocessors;
    private final TrainedModel trainedModel;
    public static final JsonpDeserializer<Definition> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Definition::setupDefinitionDeserializer);

    private Definition(Builder builder) {
        this.preprocessors = ApiTypeHelper.unmodifiable(builder.preprocessors);
        this.trainedModel = ApiTypeHelper.requireNonNull(builder.trainedModel, this, "trainedModel");
    }

    public static Definition of(Function<Builder, ObjectBuilder<Definition>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<Preprocessor> preprocessors() {
        return this.preprocessors;
    }

    public final TrainedModel trainedModel() {
        return this.trainedModel;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.preprocessors)) {
            generator.writeKey("preprocessors");
            generator.writeStartArray();
            for (Preprocessor item0 : this.preprocessors) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("trained_model");
        this.trainedModel.serialize(generator, mapper);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupDefinitionDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::preprocessors, JsonpDeserializer.arrayDeserializer(Preprocessor._DESERIALIZER), "preprocessors");
        op.add(Builder::trainedModel, TrainedModel._DESERIALIZER, "trained_model");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<Definition> {
        @Nullable
        private List<Preprocessor> preprocessors;
        private TrainedModel trainedModel;

        public final Builder preprocessors(List<Preprocessor> list) {
            this.preprocessors = Builder._listAddAll(this.preprocessors, list);
            return this;
        }

        public final Builder preprocessors(Preprocessor value, Preprocessor ... values) {
            this.preprocessors = Builder._listAdd(this.preprocessors, value, values);
            return this;
        }

        public final Builder preprocessors(Function<Preprocessor.Builder, ObjectBuilder<Preprocessor>> fn) {
            return this.preprocessors(fn.apply(new Preprocessor.Builder()).build(), new Preprocessor[0]);
        }

        public final Builder trainedModel(TrainedModel value) {
            this.trainedModel = value;
            return this;
        }

        public final Builder trainedModel(Function<TrainedModel.Builder, ObjectBuilder<TrainedModel>> fn) {
            return this.trainedModel(fn.apply(new TrainedModel.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Definition build() {
            this._checkSingleUse();
            return new Definition(this);
        }
    }
}

