/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch.security.FieldRuleVariant;
import co.elastic.clients.elasticsearch.security.Realm;
import co.elastic.clients.elasticsearch.security.RoleMappingRule;
import co.elastic.clients.elasticsearch.security.RoleMappingRuleVariant;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonEnum;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class FieldRule
implements TaggedUnion<Kind, Object>,
RoleMappingRuleVariant,
JsonpSerializable {
    private final Kind _kind;
    private final Object _value;
    public static final JsonpDeserializer<FieldRule> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FieldRule::setupFieldRuleDeserializer, Builder::build);

    @Override
    public RoleMappingRule.Kind _roleMappingRuleKind() {
        return RoleMappingRule.Kind.Field;
    }

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    public FieldRule(FieldRuleVariant value) {
        this._kind = ApiTypeHelper.requireNonNull(value._fieldRuleKind(), this, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(value, this, "<variant value>");
    }

    private FieldRule(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static FieldRule of(Function<Builder, ObjectBuilder<FieldRule>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isUsername() {
        return this._kind == Kind.Username;
    }

    public String username() {
        return (String)TaggedUnionUtils.get(this, Kind.Username);
    }

    public boolean isDn() {
        return this._kind == Kind.Dn;
    }

    public List<String> dn() {
        return (List)TaggedUnionUtils.get(this, Kind.Dn);
    }

    public boolean isGroups() {
        return this._kind == Kind.Groups;
    }

    public List<String> groups() {
        return (List)TaggedUnionUtils.get(this, Kind.Groups);
    }

    public boolean isMetadata() {
        return this._kind == Kind.Metadata;
    }

    public JsonData metadata() {
        return (JsonData)TaggedUnionUtils.get(this, Kind.Metadata);
    }

    public boolean isRealm() {
        return this._kind == Kind.Realm;
    }

    public Realm realm() {
        return (Realm)TaggedUnionUtils.get(this, Kind.Realm);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        generator.writeKey(this._kind.jsonValue());
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        } else {
            switch (this._kind) {
                case Username: {
                    generator.write((String)this._value);
                    break;
                }
                case Dn: {
                    generator.writeStartArray();
                    for (String item0 : (List)this._value) {
                        generator.write(item0);
                    }
                    generator.writeEnd();
                    break;
                }
                case Groups: {
                    generator.writeStartArray();
                    for (String item0 : (List)this._value) {
                        generator.write(item0);
                    }
                    generator.writeEnd();
                    break;
                }
                case Metadata: {
                    ((JsonData)this._value).serialize(generator, mapper);
                }
            }
        }
        generator.writeEnd();
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupFieldRuleDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::username, JsonpDeserializer.stringDeserializer(), "username");
        op.add(Builder::dn, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "dn");
        op.add(Builder::groups, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "groups");
        op.add(Builder::metadata, JsonData._DESERIALIZER, "metadata");
        op.add(Builder::realm, Realm._DESERIALIZER, "realm");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<FieldRule> {
        private Kind _kind;
        private Object _value;

        @Override
        protected Builder self() {
            return this;
        }

        public ObjectBuilder<FieldRule> username(String v) {
            this._kind = Kind.Username;
            this._value = v;
            return this;
        }

        public ObjectBuilder<FieldRule> dn(List<String> v) {
            this._kind = Kind.Dn;
            this._value = v;
            return this;
        }

        public ObjectBuilder<FieldRule> groups(List<String> v) {
            this._kind = Kind.Groups;
            this._value = v;
            return this;
        }

        public ObjectBuilder<FieldRule> metadata(JsonData v) {
            this._kind = Kind.Metadata;
            this._value = v;
            return this;
        }

        public ObjectBuilder<FieldRule> realm(Realm v) {
            this._kind = Kind.Realm;
            this._value = v;
            return this;
        }

        public ObjectBuilder<FieldRule> realm(Function<Realm.Builder, ObjectBuilder<Realm>> fn) {
            return this.realm(fn.apply(new Realm.Builder()).build());
        }

        @Override
        public FieldRule build() {
            this._checkSingleUse();
            return new FieldRule(this);
        }
    }

    public static enum Kind implements JsonEnum
    {
        Username("username"),
        Dn("dn"),
        Groups("groups"),
        Metadata("metadata"),
        Realm("realm");

        private final String jsonValue;

        private Kind(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        @Override
        public String jsonValue() {
            return this.jsonValue;
        }
    }
}

