/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.watcher.WatcherStatsResponse;
import co.elastic.clients.elasticsearch.watcher.stats.WatcherMetric;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class WatcherStatsRequest
extends RequestBase {
    @Nullable
    private final Boolean emitStacktraces;
    private final List<WatcherMetric> metric;
    public static final Endpoint<WatcherStatsRequest, WatcherStatsResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<WatcherStatsRequest, WatcherStatsResponse>("es/watcher.stats", request -> "GET", request -> {
        boolean _metric = true;
        boolean propsSet = false;
        if (ApiTypeHelper.isDefined(request.metric())) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_watcher");
            buf.append("/stats");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_watcher");
            buf.append("/stats");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.metric.stream().map(v -> v.jsonValue()).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.emitStacktraces != null) {
            params.put("emit_stacktraces", String.valueOf(request.emitStacktraces));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, WatcherStatsResponse._DESERIALIZER);

    private WatcherStatsRequest(Builder builder) {
        this.emitStacktraces = builder.emitStacktraces;
        this.metric = ApiTypeHelper.unmodifiable(builder.metric);
    }

    public static WatcherStatsRequest of(Function<Builder, ObjectBuilder<WatcherStatsRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean emitStacktraces() {
        return this.emitStacktraces;
    }

    public final List<WatcherMetric> metric() {
        return this.metric;
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<WatcherStatsRequest> {
        @Nullable
        private Boolean emitStacktraces;
        @Nullable
        private List<WatcherMetric> metric;

        public final Builder emitStacktraces(@Nullable Boolean value) {
            this.emitStacktraces = value;
            return this;
        }

        public final Builder metric(List<WatcherMetric> list) {
            this.metric = Builder._listAddAll(this.metric, list);
            return this;
        }

        public final Builder metric(WatcherMetric value, WatcherMetric ... values) {
            this.metric = Builder._listAdd(this.metric, value, values);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public WatcherStatsRequest build() {
            this._checkSingleUse();
            return new WatcherStatsRequest(this);
        }
    }
}

